/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTestSetGenerationRequest extends LexModelsV2Request implements
        ToCopyableBuilder<StartTestSetGenerationRequest.Builder, StartTestSetGenerationRequest> {
    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSetName").getter(getter(StartTestSetGenerationRequest::testSetName))
            .setter(setter(Builder::testSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StartTestSetGenerationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<TestSetStorageLocation> STORAGE_LOCATION_FIELD = SdkField
            .<TestSetStorageLocation> builder(MarshallingType.SDK_POJO).memberName("storageLocation")
            .getter(getter(StartTestSetGenerationRequest::storageLocation)).setter(setter(Builder::storageLocation))
            .constructor(TestSetStorageLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocation").build()).build();

    private static final SdkField<TestSetGenerationDataSource> GENERATION_DATA_SOURCE_FIELD = SdkField
            .<TestSetGenerationDataSource> builder(MarshallingType.SDK_POJO).memberName("generationDataSource")
            .getter(getter(StartTestSetGenerationRequest::generationDataSource)).setter(setter(Builder::generationDataSource))
            .constructor(TestSetGenerationDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationDataSource").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(StartTestSetGenerationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> TEST_SET_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("testSetTags")
            .getter(getter(StartTestSetGenerationRequest::testSetTags))
            .setter(setter(Builder::testSetTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_NAME_FIELD,
            DESCRIPTION_FIELD, STORAGE_LOCATION_FIELD, GENERATION_DATA_SOURCE_FIELD, ROLE_ARN_FIELD, TEST_SET_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testSetName;

    private final String description;

    private final TestSetStorageLocation storageLocation;

    private final TestSetGenerationDataSource generationDataSource;

    private final String roleArn;

    private final Map<String, String> testSetTags;

    private StartTestSetGenerationRequest(BuilderImpl builder) {
        super(builder);
        this.testSetName = builder.testSetName;
        this.description = builder.description;
        this.storageLocation = builder.storageLocation;
        this.generationDataSource = builder.generationDataSource;
        this.roleArn = builder.roleArn;
        this.testSetTags = builder.testSetTags;
    }

    /**
     * <p>
     * The test set name for the test set generation request.
     * </p>
     * 
     * @return The test set name for the test set generation request.
     */
    public final String testSetName() {
        return testSetName;
    }

    /**
     * <p>
     * The test set description for the test set generation request.
     * </p>
     * 
     * @return The test set description for the test set generation request.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon S3 storage location for the test set generation.
     * </p>
     * 
     * @return The Amazon S3 storage location for the test set generation.
     */
    public final TestSetStorageLocation storageLocation() {
        return storageLocation;
    }

    /**
     * <p>
     * The data source for the test set generation.
     * </p>
     * 
     * @return The data source for the test set generation.
     */
    public final TestSetGenerationDataSource generationDataSource() {
        return generationDataSource;
    }

    /**
     * <p>
     * The roleARN used for any operation in the test set to access resources in the Amazon Web Services account.
     * </p>
     * 
     * @return The roleARN used for any operation in the test set to access resources in the Amazon Web Services
     *         account.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TestSetTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTestSetTags() {
        return testSetTags != null && !(testSetTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to add to the test set. You can only add tags when you import/generate a new test set. You can't
     * use the <code>UpdateTestSet</code> operation to update tags. To update tags, use the <code>TagResource</code>
     * operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTestSetTags} method.
     * </p>
     * 
     * @return A list of tags to add to the test set. You can only add tags when you import/generate a new test set. You
     *         can't use the <code>UpdateTestSet</code> operation to update tags. To update tags, use the
     *         <code>TagResource</code> operation.
     */
    public final Map<String, String> testSetTags() {
        return testSetTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(generationDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTestSetTags() ? testSetTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTestSetGenerationRequest)) {
            return false;
        }
        StartTestSetGenerationRequest other = (StartTestSetGenerationRequest) obj;
        return Objects.equals(testSetName(), other.testSetName()) && Objects.equals(description(), other.description())
                && Objects.equals(storageLocation(), other.storageLocation())
                && Objects.equals(generationDataSource(), other.generationDataSource())
                && Objects.equals(roleArn(), other.roleArn()) && hasTestSetTags() == other.hasTestSetTags()
                && Objects.equals(testSetTags(), other.testSetTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTestSetGenerationRequest").add("TestSetName", testSetName())
                .add("Description", description()).add("StorageLocation", storageLocation())
                .add("GenerationDataSource", generationDataSource()).add("RoleArn", roleArn())
                .add("TestSetTags", hasTestSetTags() ? testSetTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSetName":
            return Optional.ofNullable(clazz.cast(testSetName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "storageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        case "generationDataSource":
            return Optional.ofNullable(clazz.cast(generationDataSource()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "testSetTags":
            return Optional.ofNullable(clazz.cast(testSetTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testSetName", TEST_SET_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("storageLocation", STORAGE_LOCATION_FIELD);
        map.put("generationDataSource", GENERATION_DATA_SOURCE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("testSetTags", TEST_SET_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTestSetGenerationRequest, T> g) {
        return obj -> g.apply((StartTestSetGenerationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, StartTestSetGenerationRequest> {
        /**
         * <p>
         * The test set name for the test set generation request.
         * </p>
         * 
         * @param testSetName
         *        The test set name for the test set generation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetName(String testSetName);

        /**
         * <p>
         * The test set description for the test set generation request.
         * </p>
         * 
         * @param description
         *        The test set description for the test set generation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon S3 storage location for the test set generation.
         * </p>
         * 
         * @param storageLocation
         *        The Amazon S3 storage location for the test set generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(TestSetStorageLocation storageLocation);

        /**
         * <p>
         * The Amazon S3 storage location for the test set generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestSetStorageLocation.Builder} avoiding
         * the need to create one manually via {@link TestSetStorageLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetStorageLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #storageLocation(TestSetStorageLocation)}.
         * 
         * @param storageLocation
         *        a consumer that will call methods on {@link TestSetStorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocation(TestSetStorageLocation)
         */
        default Builder storageLocation(Consumer<TestSetStorageLocation.Builder> storageLocation) {
            return storageLocation(TestSetStorageLocation.builder().applyMutation(storageLocation).build());
        }

        /**
         * <p>
         * The data source for the test set generation.
         * </p>
         * 
         * @param generationDataSource
         *        The data source for the test set generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationDataSource(TestSetGenerationDataSource generationDataSource);

        /**
         * <p>
         * The data source for the test set generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestSetGenerationDataSource.Builder}
         * avoiding the need to create one manually via {@link TestSetGenerationDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetGenerationDataSource.Builder#build()} is called
         * immediately and its result is passed to {@link #generationDataSource(TestSetGenerationDataSource)}.
         * 
         * @param generationDataSource
         *        a consumer that will call methods on {@link TestSetGenerationDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generationDataSource(TestSetGenerationDataSource)
         */
        default Builder generationDataSource(Consumer<TestSetGenerationDataSource.Builder> generationDataSource) {
            return generationDataSource(TestSetGenerationDataSource.builder().applyMutation(generationDataSource).build());
        }

        /**
         * <p>
         * The roleARN used for any operation in the test set to access resources in the Amazon Web Services account.
         * </p>
         * 
         * @param roleArn
         *        The roleARN used for any operation in the test set to access resources in the Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of tags to add to the test set. You can only add tags when you import/generate a new test set. You
         * can't use the <code>UpdateTestSet</code> operation to update tags. To update tags, use the
         * <code>TagResource</code> operation.
         * </p>
         * 
         * @param testSetTags
         *        A list of tags to add to the test set. You can only add tags when you import/generate a new test set.
         *        You can't use the <code>UpdateTestSet</code> operation to update tags. To update tags, use the
         *        <code>TagResource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetTags(Map<String, String> testSetTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String testSetName;

        private String description;

        private TestSetStorageLocation storageLocation;

        private TestSetGenerationDataSource generationDataSource;

        private String roleArn;

        private Map<String, String> testSetTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTestSetGenerationRequest model) {
            super(model);
            testSetName(model.testSetName);
            description(model.description);
            storageLocation(model.storageLocation);
            generationDataSource(model.generationDataSource);
            roleArn(model.roleArn);
            testSetTags(model.testSetTags);
        }

        public final String getTestSetName() {
            return testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TestSetStorageLocation.Builder getStorageLocation() {
            return storageLocation != null ? storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(TestSetStorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(TestSetStorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final TestSetGenerationDataSource.Builder getGenerationDataSource() {
            return generationDataSource != null ? generationDataSource.toBuilder() : null;
        }

        public final void setGenerationDataSource(TestSetGenerationDataSource.BuilderImpl generationDataSource) {
            this.generationDataSource = generationDataSource != null ? generationDataSource.build() : null;
        }

        @Override
        public final Builder generationDataSource(TestSetGenerationDataSource generationDataSource) {
            this.generationDataSource = generationDataSource;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTestSetTags() {
            if (testSetTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return testSetTags;
        }

        public final void setTestSetTags(Map<String, String> testSetTags) {
            this.testSetTags = TagMapCopier.copy(testSetTags);
        }

        @Override
        public final Builder testSetTags(Map<String, String> testSetTags) {
            this.testSetTags = TagMapCopier.copy(testSetTags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTestSetGenerationRequest build() {
            return new StartTestSetGenerationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
