/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBotResourceGenerationResponse extends LexModelsV2Response implements
        ToCopyableBuilder<StartBotResourceGenerationResponse.Builder, StartBotResourceGenerationResponse> {
    private static final SdkField<String> GENERATION_INPUT_PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationInputPrompt").getter(getter(StartBotResourceGenerationResponse::generationInputPrompt))
            .setter(setter(Builder::generationInputPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationInputPrompt").build())
            .build();

    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationId").getter(getter(StartBotResourceGenerationResponse::generationId))
            .setter(setter(Builder::generationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()).build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(StartBotResourceGenerationResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(StartBotResourceGenerationResponse::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(StartBotResourceGenerationResponse::localeId))
            .setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationStatus").getter(getter(StartBotResourceGenerationResponse::generationStatusAsString))
            .setter(setter(Builder::generationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(StartBotResourceGenerationResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_INPUT_PROMPT_FIELD,
            GENERATION_ID_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, GENERATION_STATUS_FIELD,
            CREATION_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String generationInputPrompt;

    private final String generationId;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String generationStatus;

    private final Instant creationDateTime;

    private StartBotResourceGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.generationInputPrompt = builder.generationInputPrompt;
        this.generationId = builder.generationId;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.generationStatus = builder.generationStatus;
        this.creationDateTime = builder.creationDateTime;
    }

    /**
     * <p>
     * The prompt that was used generate intents and slot types for the bot locale.
     * </p>
     * 
     * @return The prompt that was used generate intents and slot types for the bot locale.
     */
    public final String generationInputPrompt() {
        return generationInputPrompt;
    }

    /**
     * <p>
     * The unique identifier of the generation request.
     * </p>
     * 
     * @return The unique identifier of the generation request.
     */
    public final String generationId() {
        return generationId;
    }

    /**
     * <p>
     * The unique identifier of the bot for which the generation request was made.
     * </p>
     * 
     * @return The unique identifier of the bot for which the generation request was made.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot for which the generation request was made.
     * </p>
     * 
     * @return The version of the bot for which the generation request was made.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The locale of the bot for which the generation request was made.
     * </p>
     * 
     * @return The locale of the bot for which the generation request was made.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The status of the generation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return The status of the generation request.
     * @see GenerationStatus
     */
    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(generationStatus);
    }

    /**
     * <p>
     * The status of the generation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return The status of the generation request.
     * @see GenerationStatus
     */
    public final String generationStatusAsString() {
        return generationStatus;
    }

    /**
     * <p>
     * The date and time at which the generation request was made.
     * </p>
     * 
     * @return The date and time at which the generation request was made.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(generationInputPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(generationId());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBotResourceGenerationResponse)) {
            return false;
        }
        StartBotResourceGenerationResponse other = (StartBotResourceGenerationResponse) obj;
        return Objects.equals(generationInputPrompt(), other.generationInputPrompt())
                && Objects.equals(generationId(), other.generationId()) && Objects.equals(botId(), other.botId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(generationStatusAsString(), other.generationStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartBotResourceGenerationResponse").add("GenerationInputPrompt", generationInputPrompt())
                .add("GenerationId", generationId()).add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("GenerationStatus", generationStatusAsString())
                .add("CreationDateTime", creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "generationInputPrompt":
            return Optional.ofNullable(clazz.cast(generationInputPrompt()));
        case "generationId":
            return Optional.ofNullable(clazz.cast(generationId()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "generationStatus":
            return Optional.ofNullable(clazz.cast(generationStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("generationInputPrompt", GENERATION_INPUT_PROMPT_FIELD);
        map.put("generationId", GENERATION_ID_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("generationStatus", GENERATION_STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartBotResourceGenerationResponse, T> g) {
        return obj -> g.apply((StartBotResourceGenerationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, StartBotResourceGenerationResponse> {
        /**
         * <p>
         * The prompt that was used generate intents and slot types for the bot locale.
         * </p>
         * 
         * @param generationInputPrompt
         *        The prompt that was used generate intents and slot types for the bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationInputPrompt(String generationInputPrompt);

        /**
         * <p>
         * The unique identifier of the generation request.
         * </p>
         * 
         * @param generationId
         *        The unique identifier of the generation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationId(String generationId);

        /**
         * <p>
         * The unique identifier of the bot for which the generation request was made.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot for which the generation request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot for which the generation request was made.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot for which the generation request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The locale of the bot for which the generation request was made.
         * </p>
         * 
         * @param localeId
         *        The locale of the bot for which the generation request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The status of the generation request.
         * </p>
         * 
         * @param generationStatus
         *        The status of the generation request.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(String generationStatus);

        /**
         * <p>
         * The status of the generation request.
         * </p>
         * 
         * @param generationStatus
         *        The status of the generation request.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(GenerationStatus generationStatus);

        /**
         * <p>
         * The date and time at which the generation request was made.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time at which the generation request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String generationInputPrompt;

        private String generationId;

        private String botId;

        private String botVersion;

        private String localeId;

        private String generationStatus;

        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBotResourceGenerationResponse model) {
            super(model);
            generationInputPrompt(model.generationInputPrompt);
            generationId(model.generationId);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            generationStatus(model.generationStatus);
            creationDateTime(model.creationDateTime);
        }

        public final String getGenerationInputPrompt() {
            return generationInputPrompt;
        }

        public final void setGenerationInputPrompt(String generationInputPrompt) {
            this.generationInputPrompt = generationInputPrompt;
        }

        @Override
        public final Builder generationInputPrompt(String generationInputPrompt) {
            this.generationInputPrompt = generationInputPrompt;
            return this;
        }

        public final String getGenerationId() {
            return generationId;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getGenerationStatus() {
            return generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public StartBotResourceGenerationResponse build() {
            return new StartBotResourceGenerationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
