/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The slot values that Amazon Lex uses when it sets slot values in a dialog step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotValueOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotValueOverride.Builder, SlotValueOverride> {
    private static final SdkField<String> SHAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("shape")
            .getter(getter(SlotValueOverride::shapeAsString)).setter(setter(Builder::shape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()).build();

    private static final SdkField<SlotValue> VALUE_FIELD = SdkField.<SlotValue> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(SlotValueOverride::value)).setter(setter(Builder::value))
            .constructor(SlotValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<List<SlotValueOverride>> VALUES_FIELD = SdkField
            .<List<SlotValueOverride>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(SlotValueOverride::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotValueOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotValueOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHAPE_FIELD, VALUE_FIELD,
            VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String shape;

    private final SlotValue value;

    private final List<SlotValueOverride> values;

    private SlotValueOverride(BuilderImpl builder) {
        this.shape = builder.shape;
        this.value = builder.value;
        this.values = builder.values;
    }

    /**
     * <p>
     * When the shape value is <code>List</code>, it indicates that the <code>values</code> field contains a list of
     * slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code> field contains a
     * single value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shape} will return
     * {@link SlotShape#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shapeAsString}.
     * </p>
     * 
     * @return When the shape value is <code>List</code>, it indicates that the <code>values</code> field contains a
     *         list of slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code>
     *         field contains a single value.
     * @see SlotShape
     */
    public final SlotShape shape() {
        return SlotShape.fromValue(shape);
    }

    /**
     * <p>
     * When the shape value is <code>List</code>, it indicates that the <code>values</code> field contains a list of
     * slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code> field contains a
     * single value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shape} will return
     * {@link SlotShape#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shapeAsString}.
     * </p>
     * 
     * @return When the shape value is <code>List</code>, it indicates that the <code>values</code> field contains a
     *         list of slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code>
     *         field contains a single value.
     * @see SlotShape
     */
    public final String shapeAsString() {
        return shape;
    }

    /**
     * <p>
     * The current value of the slot.
     * </p>
     * 
     * @return The current value of the slot.
     */
    public final SlotValue value() {
        return value;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more values that the user provided for the slot. For example, for a slot that elicits pizza
     * toppings, the values might be "pepperoni" and "pineapple."
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of one or more values that the user provided for the slot. For example, for a slot that elicits
     *         pizza toppings, the values might be "pepperoni" and "pineapple."
     */
    public final List<SlotValueOverride> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shapeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotValueOverride)) {
            return false;
        }
        SlotValueOverride other = (SlotValueOverride) obj;
        return Objects.equals(shapeAsString(), other.shapeAsString()) && Objects.equals(value(), other.value())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotValueOverride").add("Shape", shapeAsString()).add("Value", value())
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "shape":
            return Optional.ofNullable(clazz.cast(shapeAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("shape", SHAPE_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotValueOverride, T> g) {
        return obj -> g.apply((SlotValueOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotValueOverride> {
        /**
         * <p>
         * When the shape value is <code>List</code>, it indicates that the <code>values</code> field contains a list of
         * slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code> field contains a
         * single value.
         * </p>
         * 
         * @param shape
         *        When the shape value is <code>List</code>, it indicates that the <code>values</code> field contains a
         *        list of slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code>
         *        field contains a single value.
         * @see SlotShape
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotShape
         */
        Builder shape(String shape);

        /**
         * <p>
         * When the shape value is <code>List</code>, it indicates that the <code>values</code> field contains a list of
         * slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code> field contains a
         * single value.
         * </p>
         * 
         * @param shape
         *        When the shape value is <code>List</code>, it indicates that the <code>values</code> field contains a
         *        list of slot values. When the value is <code>Scalar</code>, it indicates that the <code>value</code>
         *        field contains a single value.
         * @see SlotShape
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotShape
         */
        Builder shape(SlotShape shape);

        /**
         * <p>
         * The current value of the slot.
         * </p>
         * 
         * @param value
         *        The current value of the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(SlotValue value);

        /**
         * <p>
         * The current value of the slot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotValue.Builder} avoiding the need to
         * create one manually via {@link SlotValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotValue.Builder#build()} is called immediately and its result
         * is passed to {@link #value(SlotValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link SlotValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(SlotValue)
         */
        default Builder value(Consumer<SlotValue.Builder> value) {
            return value(SlotValue.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * A list of one or more values that the user provided for the slot. For example, for a slot that elicits pizza
         * toppings, the values might be "pepperoni" and "pineapple."
         * </p>
         * 
         * @param values
         *        A list of one or more values that the user provided for the slot. For example, for a slot that elicits
         *        pizza toppings, the values might be "pepperoni" and "pineapple."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<SlotValueOverride> values);

        /**
         * <p>
         * A list of one or more values that the user provided for the slot. For example, for a slot that elicits pizza
         * toppings, the values might be "pepperoni" and "pineapple."
         * </p>
         * 
         * @param values
         *        A list of one or more values that the user provided for the slot. For example, for a slot that elicits
         *        pizza toppings, the values might be "pepperoni" and "pineapple."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(SlotValueOverride... values);

        /**
         * <p>
         * A list of one or more values that the user provided for the slot. For example, for a slot that elicits pizza
         * toppings, the values might be "pepperoni" and "pineapple."
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotValueOverride.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotValueOverride#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotValueOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #values(List<SlotValueOverride>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SlotValueOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<SlotValueOverride>)
         */
        Builder values(Consumer<Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private String shape;

        private SlotValue value;

        private List<SlotValueOverride> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotValueOverride model) {
            shape(model.shape);
            value(model.value);
            values(model.values);
        }

        public final String getShape() {
            return shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        @Override
        public final Builder shape(SlotShape shape) {
            this.shape(shape == null ? null : shape.toString());
            return this;
        }

        public final SlotValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(SlotValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(SlotValue value) {
            this.value = value;
            return this;
        }

        public final List<Builder> getValues() {
            List<Builder> result = SlotValuesCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<BuilderImpl> values) {
            this.values = SlotValuesCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<SlotValueOverride> values) {
            this.values = SlotValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(SlotValueOverride... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<Builder>... values) {
            values(Stream.of(values).map(c -> SlotValueOverride.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SlotValueOverride build() {
            return new SlotValueOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
