/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains specifications for the assisted slot resolution feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotResolutionImprovementSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotResolutionImprovementSpecification.Builder, SlotResolutionImprovementSpecification> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(SlotResolutionImprovementSpecification::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<BedrockModelSpecification> BEDROCK_MODEL_SPECIFICATION_FIELD = SdkField
            .<BedrockModelSpecification> builder(MarshallingType.SDK_POJO).memberName("bedrockModelSpecification")
            .getter(getter(SlotResolutionImprovementSpecification::bedrockModelSpecification))
            .setter(setter(Builder::bedrockModelSpecification)).constructor(BedrockModelSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelSpecification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            BEDROCK_MODEL_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final BedrockModelSpecification bedrockModelSpecification;

    private SlotResolutionImprovementSpecification(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.bedrockModelSpecification = builder.bedrockModelSpecification;
    }

    /**
     * <p>
     * Specifies whether assisted slot resolution is turned on or off.
     * </p>
     * 
     * @return Specifies whether assisted slot resolution is turned on or off.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * An object containing information about the Amazon Bedrock model used to assist slot resolution.
     * </p>
     * 
     * @return An object containing information about the Amazon Bedrock model used to assist slot resolution.
     */
    public final BedrockModelSpecification bedrockModelSpecification() {
        return bedrockModelSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(bedrockModelSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotResolutionImprovementSpecification)) {
            return false;
        }
        SlotResolutionImprovementSpecification other = (SlotResolutionImprovementSpecification) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(bedrockModelSpecification(), other.bedrockModelSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotResolutionImprovementSpecification").add("Enabled", enabled())
                .add("BedrockModelSpecification", bedrockModelSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "bedrockModelSpecification":
            return Optional.ofNullable(clazz.cast(bedrockModelSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("bedrockModelSpecification", BEDROCK_MODEL_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotResolutionImprovementSpecification, T> g) {
        return obj -> g.apply((SlotResolutionImprovementSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotResolutionImprovementSpecification> {
        /**
         * <p>
         * Specifies whether assisted slot resolution is turned on or off.
         * </p>
         * 
         * @param enabled
         *        Specifies whether assisted slot resolution is turned on or off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * An object containing information about the Amazon Bedrock model used to assist slot resolution.
         * </p>
         * 
         * @param bedrockModelSpecification
         *        An object containing information about the Amazon Bedrock model used to assist slot resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockModelSpecification(BedrockModelSpecification bedrockModelSpecification);

        /**
         * <p>
         * An object containing information about the Amazon Bedrock model used to assist slot resolution.
         * </p>
         * This is a convenience method that creates an instance of the {@link BedrockModelSpecification.Builder}
         * avoiding the need to create one manually via {@link BedrockModelSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockModelSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #bedrockModelSpecification(BedrockModelSpecification)}.
         * 
         * @param bedrockModelSpecification
         *        a consumer that will call methods on {@link BedrockModelSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockModelSpecification(BedrockModelSpecification)
         */
        default Builder bedrockModelSpecification(Consumer<BedrockModelSpecification.Builder> bedrockModelSpecification) {
            return bedrockModelSpecification(BedrockModelSpecification.builder().applyMutation(bedrockModelSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private BedrockModelSpecification bedrockModelSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotResolutionImprovementSpecification model) {
            enabled(model.enabled);
            bedrockModelSpecification(model.bedrockModelSpecification);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final BedrockModelSpecification.Builder getBedrockModelSpecification() {
            return bedrockModelSpecification != null ? bedrockModelSpecification.toBuilder() : null;
        }

        public final void setBedrockModelSpecification(BedrockModelSpecification.BuilderImpl bedrockModelSpecification) {
            this.bedrockModelSpecification = bedrockModelSpecification != null ? bedrockModelSpecification.build() : null;
        }

        @Override
        public final Builder bedrockModelSpecification(BedrockModelSpecification bedrockModelSpecification) {
            this.bedrockModelSpecification = bedrockModelSpecification;
            return this;
        }

        @Override
        public SlotResolutionImprovementSpecification build() {
            return new SlotResolutionImprovementSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
