/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the the configuration of the built-in <code>Amazon.QnAIntent</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QnAIntentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<QnAIntentConfiguration.Builder, QnAIntentConfiguration> {
    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("dataSourceConfiguration")
            .getter(getter(QnAIntentConfiguration::dataSourceConfiguration)).setter(setter(Builder::dataSourceConfiguration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfiguration").build())
            .build();

    private static final SdkField<BedrockModelSpecification> BEDROCK_MODEL_CONFIGURATION_FIELD = SdkField
            .<BedrockModelSpecification> builder(MarshallingType.SDK_POJO).memberName("bedrockModelConfiguration")
            .getter(getter(QnAIntentConfiguration::bedrockModelConfiguration)).setter(setter(Builder::bedrockModelConfiguration))
            .constructor(BedrockModelSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_SOURCE_CONFIGURATION_FIELD, BEDROCK_MODEL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataSourceConfiguration dataSourceConfiguration;

    private final BedrockModelSpecification bedrockModelConfiguration;

    private QnAIntentConfiguration(BuilderImpl builder) {
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.bedrockModelConfiguration = builder.bedrockModelConfiguration;
    }

    /**
     * <p>
     * Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
     * </p>
     * 
     * @return Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
     */
    public final DataSourceConfiguration dataSourceConfiguration() {
        return dataSourceConfiguration;
    }

    /**
     * Returns the value of the BedrockModelConfiguration property for this object.
     * 
     * @return The value of the BedrockModelConfiguration property for this object.
     */
    public final BedrockModelSpecification bedrockModelConfiguration() {
        return bedrockModelConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bedrockModelConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QnAIntentConfiguration)) {
            return false;
        }
        QnAIntentConfiguration other = (QnAIntentConfiguration) obj;
        return Objects.equals(dataSourceConfiguration(), other.dataSourceConfiguration())
                && Objects.equals(bedrockModelConfiguration(), other.bedrockModelConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QnAIntentConfiguration").add("DataSourceConfiguration", dataSourceConfiguration())
                .add("BedrockModelConfiguration", bedrockModelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceConfiguration":
            return Optional.ofNullable(clazz.cast(dataSourceConfiguration()));
        case "bedrockModelConfiguration":
            return Optional.ofNullable(clazz.cast(bedrockModelConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSourceConfiguration", DATA_SOURCE_CONFIGURATION_FIELD);
        map.put("bedrockModelConfiguration", BEDROCK_MODEL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QnAIntentConfiguration, T> g) {
        return obj -> g.apply((QnAIntentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QnAIntentConfiguration> {
        /**
         * <p>
         * Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
         * </p>
         * 
         * @param dataSourceConfiguration
         *        Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration);

        /**
         * <p>
         * Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceConfiguration(DataSourceConfiguration)}.
         * 
         * @param dataSourceConfiguration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceConfiguration(DataSourceConfiguration)
         */
        default Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return dataSourceConfiguration(DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration).build());
        }

        /**
         * Sets the value of the BedrockModelConfiguration property for this object.
         *
         * @param bedrockModelConfiguration
         *        The new value for the BedrockModelConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockModelConfiguration(BedrockModelSpecification bedrockModelConfiguration);

        /**
         * Sets the value of the BedrockModelConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BedrockModelSpecification.Builder}
         * avoiding the need to create one manually via {@link BedrockModelSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockModelSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #bedrockModelConfiguration(BedrockModelSpecification)}.
         * 
         * @param bedrockModelConfiguration
         *        a consumer that will call methods on {@link BedrockModelSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockModelConfiguration(BedrockModelSpecification)
         */
        default Builder bedrockModelConfiguration(Consumer<BedrockModelSpecification.Builder> bedrockModelConfiguration) {
            return bedrockModelConfiguration(BedrockModelSpecification.builder().applyMutation(bedrockModelConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataSourceConfiguration dataSourceConfiguration;

        private BedrockModelSpecification bedrockModelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(QnAIntentConfiguration model) {
            dataSourceConfiguration(model.dataSourceConfiguration);
            bedrockModelConfiguration(model.bedrockModelConfiguration);
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return dataSourceConfiguration != null ? dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final BedrockModelSpecification.Builder getBedrockModelConfiguration() {
            return bedrockModelConfiguration != null ? bedrockModelConfiguration.toBuilder() : null;
        }

        public final void setBedrockModelConfiguration(BedrockModelSpecification.BuilderImpl bedrockModelConfiguration) {
            this.bedrockModelConfiguration = bedrockModelConfiguration != null ? bedrockModelConfiguration.build() : null;
        }

        @Override
        public final Builder bedrockModelConfiguration(BedrockModelSpecification bedrockModelConfiguration) {
            this.bedrockModelConfiguration = bedrockModelConfiguration;
            return this;
        }

        @Override
        public QnAIntentConfiguration build() {
            return new QnAIntentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
