/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUtteranceMetricsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListUtteranceMetricsResponse.Builder, ListUtteranceMetricsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListUtteranceMetricsResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<List<AnalyticsUtteranceResult>> RESULTS_FIELD = SdkField
            .<List<AnalyticsUtteranceResult>> builder(MarshallingType.LIST)
            .memberName("results")
            .getter(getter(ListUtteranceMetricsResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsUtteranceResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsUtteranceResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListUtteranceMetricsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final List<AnalyticsUtteranceResult> results;

    private final String nextToken;

    private ListUtteranceMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier for the bot for which you retrieved utterance metrics.
     * </p>
     * 
     * @return The identifier for the bot for which you retrieved utterance metrics.
     */
    public final String botId() {
        return botId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results for the utterance metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return The results for the utterance metrics.
     */
    public final List<AnalyticsUtteranceResult> results() {
        return results;
    }

    /**
     * <p>
     * If the response from the ListUtteranceMetrics operation contains more results than specified in the maxResults
     * parameter, a token is returned in the response.
     * </p>
     * <p>
     * Use the returned token in the nextToken parameter of a ListUtteranceMetrics request to return the next page of
     * results. For a complete set of results, call the ListUtteranceMetrics operation until the nextToken returned in
     * the response is null.
     * </p>
     * 
     * @return If the response from the ListUtteranceMetrics operation contains more results than specified in the
     *         maxResults parameter, a token is returned in the response.</p>
     *         <p>
     *         Use the returned token in the nextToken parameter of a ListUtteranceMetrics request to return the next
     *         page of results. For a complete set of results, call the ListUtteranceMetrics operation until the
     *         nextToken returned in the response is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUtteranceMetricsResponse)) {
            return false;
        }
        ListUtteranceMetricsResponse other = (ListUtteranceMetricsResponse) obj;
        return Objects.equals(botId(), other.botId()) && hasResults() == other.hasResults()
                && Objects.equals(results(), other.results()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUtteranceMetricsResponse").add("BotId", botId())
                .add("Results", hasResults() ? results() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("results", RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUtteranceMetricsResponse, T> g) {
        return obj -> g.apply((ListUtteranceMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListUtteranceMetricsResponse> {
        /**
         * <p>
         * The identifier for the bot for which you retrieved utterance metrics.
         * </p>
         * 
         * @param botId
         *        The identifier for the bot for which you retrieved utterance metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The results for the utterance metrics.
         * </p>
         * 
         * @param results
         *        The results for the utterance metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<AnalyticsUtteranceResult> results);

        /**
         * <p>
         * The results for the utterance metrics.
         * </p>
         * 
         * @param results
         *        The results for the utterance metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(AnalyticsUtteranceResult... results);

        /**
         * <p>
         * The results for the utterance metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceResult.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceResult.Builder#build()} is called
         * immediately and its result is passed to {@link #results(List<AnalyticsUtteranceResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(java.util.Collection<AnalyticsUtteranceResult>)
         */
        Builder results(Consumer<AnalyticsUtteranceResult.Builder>... results);

        /**
         * <p>
         * If the response from the ListUtteranceMetrics operation contains more results than specified in the
         * maxResults parameter, a token is returned in the response.
         * </p>
         * <p>
         * Use the returned token in the nextToken parameter of a ListUtteranceMetrics request to return the next page
         * of results. For a complete set of results, call the ListUtteranceMetrics operation until the nextToken
         * returned in the response is null.
         * </p>
         * 
         * @param nextToken
         *        If the response from the ListUtteranceMetrics operation contains more results than specified in the
         *        maxResults parameter, a token is returned in the response.</p>
         *        <p>
         *        Use the returned token in the nextToken parameter of a ListUtteranceMetrics request to return the next
         *        page of results. For a complete set of results, call the ListUtteranceMetrics operation until the
         *        nextToken returned in the response is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private List<AnalyticsUtteranceResult> results = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUtteranceMetricsResponse model) {
            super(model);
            botId(model.botId);
            results(model.results);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final List<AnalyticsUtteranceResult.Builder> getResults() {
            List<AnalyticsUtteranceResult.Builder> result = AnalyticsUtteranceResultsCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<AnalyticsUtteranceResult.BuilderImpl> results) {
            this.results = AnalyticsUtteranceResultsCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<AnalyticsUtteranceResult> results) {
            this.results = AnalyticsUtteranceResultsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(AnalyticsUtteranceResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<AnalyticsUtteranceResult.Builder>... results) {
            results(Stream.of(results).map(c -> AnalyticsUtteranceResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUtteranceMetricsResponse build() {
            return new ListUtteranceMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
