/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSessionAnalyticsDataRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListSessionAnalyticsDataRequest.Builder, ListSessionAnalyticsDataRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListSessionAnalyticsDataRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDateTime").getter(getter(ListSessionAnalyticsDataRequest::startDateTime))
            .setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()).build();

    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDateTime").getter(getter(ListSessionAnalyticsDataRequest::endDateTime))
            .setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()).build();

    private static final SdkField<SessionDataSortBy> SORT_BY_FIELD = SdkField
            .<SessionDataSortBy> builder(MarshallingType.SDK_POJO).memberName("sortBy")
            .getter(getter(ListSessionAnalyticsDataRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(SessionDataSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<List<AnalyticsSessionFilter>> FILTERS_FIELD = SdkField
            .<List<AnalyticsSessionFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListSessionAnalyticsDataRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsSessionFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsSessionFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSessionAnalyticsDataRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSessionAnalyticsDataRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, SORT_BY_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final Instant startDateTime;

    private final Instant endDateTime;

    private final SessionDataSortBy sortBy;

    private final List<AnalyticsSessionFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListSessionAnalyticsDataRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.sortBy = builder.sortBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier for the bot for which you want to retrieve session analytics.
     * </p>
     * 
     * @return The identifier for the bot for which you want to retrieve session analytics.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The date and time that marks the beginning of the range of time for which you want to see session analytics.
     * </p>
     * 
     * @return The date and time that marks the beginning of the range of time for which you want to see session
     *         analytics.
     */
    public final Instant startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * The date and time that marks the end of the range of time for which you want to see session analytics.
     * </p>
     * 
     * @return The date and time that marks the end of the range of time for which you want to see session analytics.
     */
    public final Instant endDateTime() {
        return endDateTime;
    }

    /**
     * <p>
     * An object specifying the measure and method by which to sort the session analytics data.
     * </p>
     * 
     * @return An object specifying the measure and method by which to sort the session analytics data.
     */
    public final SessionDataSortBy sortBy() {
        return sortBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which describes a condition by which you want to filter the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A list of objects, each of which describes a condition by which you want to filter the results.
     */
    public final List<AnalyticsSessionFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in each page of results. If there are fewer results than the maximum page
     * size, only the actual number of results are returned.
     * </p>
     * 
     * @return The maximum number of results to return in each page of results. If there are fewer results than the
     *         maximum page size, only the actual number of results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the ListSessionAnalyticsData operation contains more results than specified in the
     * maxResults parameter, a token is returned in the response.
     * </p>
     * <p>
     * Use the returned token in the nextToken parameter of a ListSessionAnalyticsData request to return the next page
     * of results. For a complete set of results, call the ListSessionAnalyticsData operation until the nextToken
     * returned in the response is null.
     * </p>
     * 
     * @return If the response from the ListSessionAnalyticsData operation contains more results than specified in the
     *         maxResults parameter, a token is returned in the response.</p>
     *         <p>
     *         Use the returned token in the nextToken parameter of a ListSessionAnalyticsData request to return the
     *         next page of results. For a complete set of results, call the ListSessionAnalyticsData operation until
     *         the nextToken returned in the response is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionAnalyticsDataRequest)) {
            return false;
        }
        ListSessionAnalyticsDataRequest other = (ListSessionAnalyticsDataRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(startDateTime(), other.startDateTime())
                && Objects.equals(endDateTime(), other.endDateTime()) && Objects.equals(sortBy(), other.sortBy())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSessionAnalyticsDataRequest").add("BotId", botId()).add("StartDateTime", startDateTime())
                .add("EndDateTime", endDateTime()).add("SortBy", sortBy()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "startDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "endDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("startDateTime", START_DATE_TIME_FIELD);
        map.put("endDateTime", END_DATE_TIME_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSessionAnalyticsDataRequest, T> g) {
        return obj -> g.apply((ListSessionAnalyticsDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSessionAnalyticsDataRequest> {
        /**
         * <p>
         * The identifier for the bot for which you want to retrieve session analytics.
         * </p>
         * 
         * @param botId
         *        The identifier for the bot for which you want to retrieve session analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The date and time that marks the beginning of the range of time for which you want to see session analytics.
         * </p>
         * 
         * @param startDateTime
         *        The date and time that marks the beginning of the range of time for which you want to see session
         *        analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(Instant startDateTime);

        /**
         * <p>
         * The date and time that marks the end of the range of time for which you want to see session analytics.
         * </p>
         * 
         * @param endDateTime
         *        The date and time that marks the end of the range of time for which you want to see session analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(Instant endDateTime);

        /**
         * <p>
         * An object specifying the measure and method by which to sort the session analytics data.
         * </p>
         * 
         * @param sortBy
         *        An object specifying the measure and method by which to sort the session analytics data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(SessionDataSortBy sortBy);

        /**
         * <p>
         * An object specifying the measure and method by which to sort the session analytics data.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionDataSortBy.Builder} avoiding the
         * need to create one manually via {@link SessionDataSortBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionDataSortBy.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(SessionDataSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link SessionDataSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(SessionDataSortBy)
         */
        default Builder sortBy(Consumer<SessionDataSortBy.Builder> sortBy) {
            return sortBy(SessionDataSortBy.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * A list of objects, each of which describes a condition by which you want to filter the results.
         * </p>
         * 
         * @param filters
         *        A list of objects, each of which describes a condition by which you want to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<AnalyticsSessionFilter> filters);

        /**
         * <p>
         * A list of objects, each of which describes a condition by which you want to filter the results.
         * </p>
         * 
         * @param filters
         *        A list of objects, each of which describes a condition by which you want to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AnalyticsSessionFilter... filters);

        /**
         * <p>
         * A list of objects, each of which describes a condition by which you want to filter the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<AnalyticsSessionFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<AnalyticsSessionFilter>)
         */
        Builder filters(Consumer<AnalyticsSessionFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return in each page of results. If there are fewer results than the maximum
         * page size, only the actual number of results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in each page of results. If there are fewer results than the
         *        maximum page size, only the actual number of results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the ListSessionAnalyticsData operation contains more results than specified in the
         * maxResults parameter, a token is returned in the response.
         * </p>
         * <p>
         * Use the returned token in the nextToken parameter of a ListSessionAnalyticsData request to return the next
         * page of results. For a complete set of results, call the ListSessionAnalyticsData operation until the
         * nextToken returned in the response is null.
         * </p>
         * 
         * @param nextToken
         *        If the response from the ListSessionAnalyticsData operation contains more results than specified in
         *        the maxResults parameter, a token is returned in the response.</p>
         *        <p>
         *        Use the returned token in the nextToken parameter of a ListSessionAnalyticsData request to return the
         *        next page of results. For a complete set of results, call the ListSessionAnalyticsData operation until
         *        the nextToken returned in the response is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private Instant startDateTime;

        private Instant endDateTime;

        private SessionDataSortBy sortBy;

        private List<AnalyticsSessionFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionAnalyticsDataRequest model) {
            super(model);
            botId(model.botId);
            startDateTime(model.startDateTime);
            endDateTime(model.endDateTime);
            sortBy(model.sortBy);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Instant getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final SessionDataSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(SessionDataSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(SessionDataSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final List<AnalyticsSessionFilter.Builder> getFilters() {
            List<AnalyticsSessionFilter.Builder> result = AnalyticsSessionFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AnalyticsSessionFilter.BuilderImpl> filters) {
            this.filters = AnalyticsSessionFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AnalyticsSessionFilter> filters) {
            this.filters = AnalyticsSessionFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AnalyticsSessionFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AnalyticsSessionFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> AnalyticsSessionFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSessionAnalyticsDataRequest build() {
            return new ListSessionAnalyticsDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
