/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotReplicasResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBotReplicasResponse.Builder, ListBotReplicasResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListBotReplicasResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRegion").getter(getter(ListBotReplicasResponse::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()).build();

    private static final SdkField<List<BotReplicaSummary>> BOT_REPLICA_SUMMARIES_FIELD = SdkField
            .<List<BotReplicaSummary>> builder(MarshallingType.LIST)
            .memberName("botReplicaSummaries")
            .getter(getter(ListBotReplicasResponse::botReplicaSummaries))
            .setter(setter(Builder::botReplicaSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botReplicaSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotReplicaSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotReplicaSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            SOURCE_REGION_FIELD, BOT_REPLICA_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String sourceRegion;

    private final List<BotReplicaSummary> botReplicaSummaries;

    private ListBotReplicasResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.sourceRegion = builder.sourceRegion;
        this.botReplicaSummaries = builder.botReplicaSummaries;
    }

    /**
     * <p>
     * the unique bot IDs in the list of replicated bots.
     * </p>
     * 
     * @return the unique bot IDs in the list of replicated bots.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The source region of the source bots in the list of replicated bots.
     * </p>
     * 
     * @return The source region of the source bots in the list of replicated bots.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotReplicaSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBotReplicaSummaries() {
        return botReplicaSummaries != null && !(botReplicaSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary details for the replicated bots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotReplicaSummaries} method.
     * </p>
     * 
     * @return The summary details for the replicated bots.
     */
    public final List<BotReplicaSummary> botReplicaSummaries() {
        return botReplicaSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotReplicaSummaries() ? botReplicaSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotReplicasResponse)) {
            return false;
        }
        ListBotReplicasResponse other = (ListBotReplicasResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(sourceRegion(), other.sourceRegion())
                && hasBotReplicaSummaries() == other.hasBotReplicaSummaries()
                && Objects.equals(botReplicaSummaries(), other.botReplicaSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotReplicasResponse").add("BotId", botId()).add("SourceRegion", sourceRegion())
                .add("BotReplicaSummaries", hasBotReplicaSummaries() ? botReplicaSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "sourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "botReplicaSummaries":
            return Optional.ofNullable(clazz.cast(botReplicaSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("sourceRegion", SOURCE_REGION_FIELD);
        map.put("botReplicaSummaries", BOT_REPLICA_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotReplicasResponse, T> g) {
        return obj -> g.apply((ListBotReplicasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBotReplicasResponse> {
        /**
         * <p>
         * the unique bot IDs in the list of replicated bots.
         * </p>
         * 
         * @param botId
         *        the unique bot IDs in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The source region of the source bots in the list of replicated bots.
         * </p>
         * 
         * @param sourceRegion
         *        The source region of the source bots in the list of replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The summary details for the replicated bots.
         * </p>
         * 
         * @param botReplicaSummaries
         *        The summary details for the replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botReplicaSummaries(Collection<BotReplicaSummary> botReplicaSummaries);

        /**
         * <p>
         * The summary details for the replicated bots.
         * </p>
         * 
         * @param botReplicaSummaries
         *        The summary details for the replicated bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botReplicaSummaries(BotReplicaSummary... botReplicaSummaries);

        /**
         * <p>
         * The summary details for the replicated bots.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotReplicaSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.BotReplicaSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotReplicaSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #botReplicaSummaries(List<BotReplicaSummary>)}.
         * 
         * @param botReplicaSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BotReplicaSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botReplicaSummaries(java.util.Collection<BotReplicaSummary>)
         */
        Builder botReplicaSummaries(Consumer<BotReplicaSummary.Builder>... botReplicaSummaries);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String sourceRegion;

        private List<BotReplicaSummary> botReplicaSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotReplicasResponse model) {
            super(model);
            botId(model.botId);
            sourceRegion(model.sourceRegion);
            botReplicaSummaries(model.botReplicaSummaries);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final List<BotReplicaSummary.Builder> getBotReplicaSummaries() {
            List<BotReplicaSummary.Builder> result = BotReplicaSummaryListCopier.copyToBuilder(this.botReplicaSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotReplicaSummaries(Collection<BotReplicaSummary.BuilderImpl> botReplicaSummaries) {
            this.botReplicaSummaries = BotReplicaSummaryListCopier.copyFromBuilder(botReplicaSummaries);
        }

        @Override
        public final Builder botReplicaSummaries(Collection<BotReplicaSummary> botReplicaSummaries) {
            this.botReplicaSummaries = BotReplicaSummaryListCopier.copy(botReplicaSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botReplicaSummaries(BotReplicaSummary... botReplicaSummaries) {
            botReplicaSummaries(Arrays.asList(botReplicaSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botReplicaSummaries(Consumer<BotReplicaSummary.Builder>... botReplicaSummaries) {
            botReplicaSummaries(Stream.of(botReplicaSummaries).map(c -> BotReplicaSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBotReplicasResponse build() {
            return new ListBotReplicasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
