/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotLocalesResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBotLocalesResponse.Builder, ListBotLocalesResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListBotLocalesResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListBotLocalesResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBotLocalesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<BotLocaleSummary>> BOT_LOCALE_SUMMARIES_FIELD = SdkField
            .<List<BotLocaleSummary>> builder(MarshallingType.LIST)
            .memberName("botLocaleSummaries")
            .getter(getter(ListBotLocalesResponse::botLocaleSummaries))
            .setter(setter(Builder::botLocaleSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotLocaleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotLocaleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, NEXT_TOKEN_FIELD, BOT_LOCALE_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String nextToken;

    private final List<BotLocaleSummary> botLocaleSummaries;

    private ListBotLocalesResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.nextToken = builder.nextToken;
        this.botLocaleSummaries = builder.botLocaleSummaries;
    }

    /**
     * <p>
     * The identifier of the bot to list locales for.
     * </p>
     * 
     * @return The identifier of the bot to list locales for.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot.
     * </p>
     * 
     * @return The version of the bot.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the <code>ListBotLocales</code>
     * operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code>
     * parameter of a <code>ListBotLocales</code> operation request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the
     *         contents as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to
     *         get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotLocaleSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBotLocaleSummaries() {
        return botLocaleSummaries != null && !(botLocaleSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the locales that meet the filter criteria specified in the request. The length of the
     * list is specified in the <code>maxResults</code> parameter of the request. If there are more locales available,
     * the <code>nextToken</code> field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotLocaleSummaries} method.
     * </p>
     * 
     * @return Summary information for the locales that meet the filter criteria specified in the request. The length of
     *         the list is specified in the <code>maxResults</code> parameter of the request. If there are more locales
     *         available, the <code>nextToken</code> field contains a token to get the next page of results.
     */
    public final List<BotLocaleSummary> botLocaleSummaries() {
        return botLocaleSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotLocaleSummaries() ? botLocaleSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotLocalesResponse)) {
            return false;
        }
        ListBotLocalesResponse other = (ListBotLocalesResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(nextToken(), other.nextToken()) && hasBotLocaleSummaries() == other.hasBotLocaleSummaries()
                && Objects.equals(botLocaleSummaries(), other.botLocaleSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotLocalesResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("NextToken", nextToken()).add("BotLocaleSummaries", hasBotLocaleSummaries() ? botLocaleSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "botLocaleSummaries":
            return Optional.ofNullable(clazz.cast(botLocaleSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("botLocaleSummaries", BOT_LOCALE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotLocalesResponse, T> g) {
        return obj -> g.apply((ListBotLocalesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBotLocalesResponse> {
        /**
         * <p>
         * The identifier of the bot to list locales for.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot to list locales for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the
         * <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the contents
         * as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to get the next
         * page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the
         *        contents as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to
         *        get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Summary information for the locales that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter of the request. If there are more locales
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param botLocaleSummaries
         *        Summary information for the locales that meet the filter criteria specified in the request. The length
         *        of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         *        locales available, the <code>nextToken</code> field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botLocaleSummaries(Collection<BotLocaleSummary> botLocaleSummaries);

        /**
         * <p>
         * Summary information for the locales that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter of the request. If there are more locales
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param botLocaleSummaries
         *        Summary information for the locales that meet the filter criteria specified in the request. The length
         *        of the list is specified in the <code>maxResults</code> parameter of the request. If there are more
         *        locales available, the <code>nextToken</code> field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botLocaleSummaries(BotLocaleSummary... botLocaleSummaries);

        /**
         * <p>
         * Summary information for the locales that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter of the request. If there are more locales
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #botLocaleSummaries(List<BotLocaleSummary>)}.
         * 
         * @param botLocaleSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botLocaleSummaries(java.util.Collection<BotLocaleSummary>)
         */
        Builder botLocaleSummaries(Consumer<BotLocaleSummary.Builder>... botLocaleSummaries);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String nextToken;

        private List<BotLocaleSummary> botLocaleSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotLocalesResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            nextToken(model.nextToken);
            botLocaleSummaries(model.botLocaleSummaries);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BotLocaleSummary.Builder> getBotLocaleSummaries() {
            List<BotLocaleSummary.Builder> result = BotLocaleSummaryListCopier.copyToBuilder(this.botLocaleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotLocaleSummaries(Collection<BotLocaleSummary.BuilderImpl> botLocaleSummaries) {
            this.botLocaleSummaries = BotLocaleSummaryListCopier.copyFromBuilder(botLocaleSummaries);
        }

        @Override
        public final Builder botLocaleSummaries(Collection<BotLocaleSummary> botLocaleSummaries) {
            this.botLocaleSummaries = BotLocaleSummaryListCopier.copy(botLocaleSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botLocaleSummaries(BotLocaleSummary... botLocaleSummaries) {
            botLocaleSummaries(Arrays.asList(botLocaleSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botLocaleSummaries(Consumer<BotLocaleSummary.Builder>... botLocaleSummaries) {
            botLocaleSummaries(Stream.of(botLocaleSummaries).map(c -> BotLocaleSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBotLocalesResponse build() {
            return new ListBotLocalesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
