/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBotVersionRequest extends LexModelsV2Request implements
        ToCopyableBuilder<DeleteBotVersionRequest.Builder, DeleteBotVersionRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DeleteBotVersionRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DeleteBotVersionRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<Boolean> SKIP_RESOURCE_IN_USE_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipResourceInUseCheck")
            .getter(getter(DeleteBotVersionRequest::skipResourceInUseCheck))
            .setter(setter(Builder::skipResourceInUseCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("skipResourceInUseCheck").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, SKIP_RESOURCE_IN_USE_CHECK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final Boolean skipResourceInUseCheck;

    private DeleteBotVersionRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.skipResourceInUseCheck = builder.skipResourceInUseCheck;
    }

    /**
     * <p>
     * The identifier of the bot that contains the version.
     * </p>
     * 
     * @return The identifier of the bot that contains the version.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot to delete.
     * </p>
     * 
     * @return The version of the bot to delete.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * By default, Amazon Lex checks if any other resource, such as an alias or bot network, is using the bot version
     * before it is deleted and throws a <code>ResourceInUseException</code> exception if the version is being used by
     * another resource. Set this parameter to <code>true</code> to skip this check and remove the version even if it is
     * being used by another resource.
     * </p>
     * 
     * @return By default, Amazon Lex checks if any other resource, such as an alias or bot network, is using the bot
     *         version before it is deleted and throws a <code>ResourceInUseException</code> exception if the version is
     *         being used by another resource. Set this parameter to <code>true</code> to skip this check and remove the
     *         version even if it is being used by another resource.
     */
    public final Boolean skipResourceInUseCheck() {
        return skipResourceInUseCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(skipResourceInUseCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotVersionRequest)) {
            return false;
        }
        DeleteBotVersionRequest other = (DeleteBotVersionRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(skipResourceInUseCheck(), other.skipResourceInUseCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBotVersionRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("SkipResourceInUseCheck", skipResourceInUseCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "skipResourceInUseCheck":
            return Optional.ofNullable(clazz.cast(skipResourceInUseCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("skipResourceInUseCheck", SKIP_RESOURCE_IN_USE_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBotVersionRequest, T> g) {
        return obj -> g.apply((DeleteBotVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBotVersionRequest> {
        /**
         * <p>
         * The identifier of the bot that contains the version.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot to delete.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * By default, Amazon Lex checks if any other resource, such as an alias or bot network, is using the bot
         * version before it is deleted and throws a <code>ResourceInUseException</code> exception if the version is
         * being used by another resource. Set this parameter to <code>true</code> to skip this check and remove the
         * version even if it is being used by another resource.
         * </p>
         * 
         * @param skipResourceInUseCheck
         *        By default, Amazon Lex checks if any other resource, such as an alias or bot network, is using the bot
         *        version before it is deleted and throws a <code>ResourceInUseException</code> exception if the version
         *        is being used by another resource. Set this parameter to <code>true</code> to skip this check and
         *        remove the version even if it is being used by another resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private Boolean skipResourceInUseCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotVersionRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            skipResourceInUseCheck(model.skipResourceInUseCheck);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final Boolean getSkipResourceInUseCheck() {
            return skipResourceInUseCheck;
        }

        public final void setSkipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
        }

        @Override
        public final Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBotVersionRequest build() {
            return new DeleteBotVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
