/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for integrating Deepgram speech-to-text models with Amazon Lex.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeepgramSpeechModelConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DeepgramSpeechModelConfig.Builder, DeepgramSpeechModelConfig> {
    private static final SdkField<String> API_TOKEN_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiTokenSecretArn").getter(getter(DeepgramSpeechModelConfig::apiTokenSecretArn))
            .setter(setter(Builder::apiTokenSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiTokenSecretArn").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(DeepgramSpeechModelConfig::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_TOKEN_SECRET_ARN_FIELD,
            MODEL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String apiTokenSecretArn;

    private final String modelId;

    private DeepgramSpeechModelConfig(BuilderImpl builder) {
        this.apiTokenSecretArn = builder.apiTokenSecretArn;
        this.modelId = builder.modelId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the Deepgram API token.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the Deepgram API token.
     */
    public final String apiTokenSecretArn() {
        return apiTokenSecretArn;
    }

    /**
     * <p>
     * The identifier of the Deepgram speech-to-text model to use for processing speech input.
     * </p>
     * 
     * @return The identifier of the Deepgram speech-to-text model to use for processing speech input.
     */
    public final String modelId() {
        return modelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiTokenSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeepgramSpeechModelConfig)) {
            return false;
        }
        DeepgramSpeechModelConfig other = (DeepgramSpeechModelConfig) obj;
        return Objects.equals(apiTokenSecretArn(), other.apiTokenSecretArn()) && Objects.equals(modelId(), other.modelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeepgramSpeechModelConfig").add("ApiTokenSecretArn", apiTokenSecretArn())
                .add("ModelId", modelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiTokenSecretArn":
            return Optional.ofNullable(clazz.cast(apiTokenSecretArn()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiTokenSecretArn", API_TOKEN_SECRET_ARN_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeepgramSpeechModelConfig, T> g) {
        return obj -> g.apply((DeepgramSpeechModelConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeepgramSpeechModelConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the Deepgram API token.
         * </p>
         * 
         * @param apiTokenSecretArn
         *        The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the Deepgram API token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiTokenSecretArn(String apiTokenSecretArn);

        /**
         * <p>
         * The identifier of the Deepgram speech-to-text model to use for processing speech input.
         * </p>
         * 
         * @param modelId
         *        The identifier of the Deepgram speech-to-text model to use for processing speech input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);
    }

    static final class BuilderImpl implements Builder {
        private String apiTokenSecretArn;

        private String modelId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeepgramSpeechModelConfig model) {
            apiTokenSecretArn(model.apiTokenSecretArn);
            modelId(model.modelId);
        }

        public final String getApiTokenSecretArn() {
            return apiTokenSecretArn;
        }

        public final void setApiTokenSecretArn(String apiTokenSecretArn) {
            this.apiTokenSecretArn = apiTokenSecretArn;
        }

        @Override
        public final Builder apiTokenSecretArn(String apiTokenSecretArn) {
            this.apiTokenSecretArn = apiTokenSecretArn;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        public DeepgramSpeechModelConfig build() {
            return new DeepgramSpeechModelConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
