/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBotLocaleRequest extends LexModelsV2Request implements
        ToCopyableBuilder<CreateBotLocaleRequest.Builder, CreateBotLocaleRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateBotLocaleRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(CreateBotLocaleRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(CreateBotLocaleRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateBotLocaleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("nluIntentConfidenceThreshold")
            .getter(getter(CreateBotLocaleRequest::nluIntentConfidenceThreshold))
            .setter(setter(Builder::nluIntentConfidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold")
                    .build()).build();

    private static final SdkField<VoiceSettings> VOICE_SETTINGS_FIELD = SdkField
            .<VoiceSettings> builder(MarshallingType.SDK_POJO).memberName("voiceSettings")
            .getter(getter(CreateBotLocaleRequest::voiceSettings)).setter(setter(Builder::voiceSettings))
            .constructor(VoiceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceSettings").build()).build();

    private static final SdkField<UnifiedSpeechSettings> UNIFIED_SPEECH_SETTINGS_FIELD = SdkField
            .<UnifiedSpeechSettings> builder(MarshallingType.SDK_POJO).memberName("unifiedSpeechSettings")
            .getter(getter(CreateBotLocaleRequest::unifiedSpeechSettings)).setter(setter(Builder::unifiedSpeechSettings))
            .constructor(UnifiedSpeechSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unifiedSpeechSettings").build())
            .build();

    private static final SdkField<SpeechRecognitionSettings> SPEECH_RECOGNITION_SETTINGS_FIELD = SdkField
            .<SpeechRecognitionSettings> builder(MarshallingType.SDK_POJO).memberName("speechRecognitionSettings")
            .getter(getter(CreateBotLocaleRequest::speechRecognitionSettings)).setter(setter(Builder::speechRecognitionSettings))
            .constructor(SpeechRecognitionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechRecognitionSettings").build())
            .build();

    private static final SdkField<GenerativeAISettings> GENERATIVE_AI_SETTINGS_FIELD = SdkField
            .<GenerativeAISettings> builder(MarshallingType.SDK_POJO).memberName("generativeAISettings")
            .getter(getter(CreateBotLocaleRequest::generativeAISettings)).setter(setter(Builder::generativeAISettings))
            .constructor(GenerativeAISettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeAISettings").build())
            .build();

    private static final SdkField<String> SPEECH_DETECTION_SENSITIVITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("speechDetectionSensitivity")
            .getter(getter(CreateBotLocaleRequest::speechDetectionSensitivityAsString))
            .setter(setter(Builder::speechDetectionSensitivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechDetectionSensitivity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, DESCRIPTION_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD, VOICE_SETTINGS_FIELD,
            UNIFIED_SPEECH_SETTINGS_FIELD, SPEECH_RECOGNITION_SETTINGS_FIELD, GENERATIVE_AI_SETTINGS_FIELD,
            SPEECH_DETECTION_SENSITIVITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String description;

    private final Double nluIntentConfidenceThreshold;

    private final VoiceSettings voiceSettings;

    private final UnifiedSpeechSettings unifiedSpeechSettings;

    private final SpeechRecognitionSettings speechRecognitionSettings;

    private final GenerativeAISettings generativeAISettings;

    private final String speechDetectionSensitivity;

    private CreateBotLocaleRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.description = builder.description;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.voiceSettings = builder.voiceSettings;
        this.unifiedSpeechSettings = builder.unifiedSpeechSettings;
        this.speechRecognitionSettings = builder.speechRecognitionSettings;
        this.generativeAISettings = builder.generativeAISettings;
        this.speechDetectionSensitivity = builder.speechDetectionSensitivity;
    }

    /**
     * <p>
     * The identifier of the bot to create the locale for.
     * </p>
     * 
     * @return The identifier of the bot to create the locale for.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot to create the locale for. This can only be the draft version of the bot.
     * </p>
     * 
     * @return The version of the bot to create the locale for. This can only be the draft version of the bot.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale that the bot will be used in. The string must match one of the
     * supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more
     * information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
     * languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale that the bot will be used in. The string must match one of the
     *         supported locales. All of the intents, slot types, and slots used in the bot must have the same locale.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * A description of the bot locale. Use this to help identify the bot locale in lists.
     * </p>
     * 
     * @return A description of the bot locale. Use this to help identify the bot locale in lists.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>,
     * <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents.
     * <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
     * configured for the bot.
     * </p>
     * <p>
     * For example, suppose a bot is configured with the confidence threshold of 0.80 and the
     * <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence
     * scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code>
     * operation would be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AMAZON.FallbackIntent
     * </p>
     * </li>
     * <li>
     * <p>
     * IntentA
     * </p>
     * </li>
     * <li>
     * <p>
     * IntentB
     * </p>
     * </li>
     * <li>
     * <p>
     * IntentC
     * </p>
     * </li>
     * </ul>
     * 
     * @return Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>,
     *         <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents.
     *         <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they
     *         are configured for the bot.</p>
     *         <p>
     *         For example, suppose a bot is configured with the confidence threshold of 0.80 and the
     *         <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following
     *         confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the
     *         <code>RecognizeText</code> operation would be:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AMAZON.FallbackIntent
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IntentA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IntentB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IntentC
     *         </p>
     *         </li>
     */
    public final Double nluIntentConfidenceThreshold() {
        return nluIntentConfidenceThreshold;
    }

    /**
     * <p>
     * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
     * </p>
     * 
     * @return The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
     */
    public final VoiceSettings voiceSettings() {
        return voiceSettings;
    }

    /**
     * <p>
     * Unified speech settings to configure for the new bot locale.
     * </p>
     * 
     * @return Unified speech settings to configure for the new bot locale.
     */
    public final UnifiedSpeechSettings unifiedSpeechSettings() {
        return unifiedSpeechSettings;
    }

    /**
     * <p>
     * Speech-to-text settings to configure for the new bot locale.
     * </p>
     * 
     * @return Speech-to-text settings to configure for the new bot locale.
     */
    public final SpeechRecognitionSettings speechRecognitionSettings() {
        return speechRecognitionSettings;
    }

    /**
     * Returns the value of the GenerativeAISettings property for this object.
     * 
     * @return The value of the GenerativeAISettings property for this object.
     */
    public final GenerativeAISettings generativeAISettings() {
        return generativeAISettings;
    }

    /**
     * <p>
     * The sensitivity level for voice activity detection (VAD) in the bot locale. This setting helps optimize speech
     * recognition accuracy by adjusting how the system responds to background noise during voice interactions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechDetectionSensitivity} will return {@link SpeechDetectionSensitivity#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #speechDetectionSensitivityAsString}.
     * </p>
     * 
     * @return The sensitivity level for voice activity detection (VAD) in the bot locale. This setting helps optimize
     *         speech recognition accuracy by adjusting how the system responds to background noise during voice
     *         interactions.
     * @see SpeechDetectionSensitivity
     */
    public final SpeechDetectionSensitivity speechDetectionSensitivity() {
        return SpeechDetectionSensitivity.fromValue(speechDetectionSensitivity);
    }

    /**
     * <p>
     * The sensitivity level for voice activity detection (VAD) in the bot locale. This setting helps optimize speech
     * recognition accuracy by adjusting how the system responds to background noise during voice interactions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #speechDetectionSensitivity} will return {@link SpeechDetectionSensitivity#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #speechDetectionSensitivityAsString}.
     * </p>
     * 
     * @return The sensitivity level for voice activity detection (VAD) in the bot locale. This setting helps optimize
     *         speech recognition accuracy by adjusting how the system responds to background noise during voice
     *         interactions.
     * @see SpeechDetectionSensitivity
     */
    public final String speechDetectionSensitivityAsString() {
        return speechDetectionSensitivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(voiceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(unifiedSpeechSettings());
        hashCode = 31 * hashCode + Objects.hashCode(speechRecognitionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(generativeAISettings());
        hashCode = 31 * hashCode + Objects.hashCode(speechDetectionSensitivityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotLocaleRequest)) {
            return false;
        }
        CreateBotLocaleRequest other = (CreateBotLocaleRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(description(), other.description())
                && Objects.equals(nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold())
                && Objects.equals(voiceSettings(), other.voiceSettings())
                && Objects.equals(unifiedSpeechSettings(), other.unifiedSpeechSettings())
                && Objects.equals(speechRecognitionSettings(), other.speechRecognitionSettings())
                && Objects.equals(generativeAISettings(), other.generativeAISettings())
                && Objects.equals(speechDetectionSensitivityAsString(), other.speechDetectionSensitivityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBotLocaleRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("Description", description())
                .add("NluIntentConfidenceThreshold", nluIntentConfidenceThreshold()).add("VoiceSettings", voiceSettings())
                .add("UnifiedSpeechSettings", unifiedSpeechSettings())
                .add("SpeechRecognitionSettings", speechRecognitionSettings())
                .add("GenerativeAISettings", generativeAISettings())
                .add("SpeechDetectionSensitivity", speechDetectionSensitivityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "nluIntentConfidenceThreshold":
            return Optional.ofNullable(clazz.cast(nluIntentConfidenceThreshold()));
        case "voiceSettings":
            return Optional.ofNullable(clazz.cast(voiceSettings()));
        case "unifiedSpeechSettings":
            return Optional.ofNullable(clazz.cast(unifiedSpeechSettings()));
        case "speechRecognitionSettings":
            return Optional.ofNullable(clazz.cast(speechRecognitionSettings()));
        case "generativeAISettings":
            return Optional.ofNullable(clazz.cast(generativeAISettings()));
        case "speechDetectionSensitivity":
            return Optional.ofNullable(clazz.cast(speechDetectionSensitivityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("nluIntentConfidenceThreshold", NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD);
        map.put("voiceSettings", VOICE_SETTINGS_FIELD);
        map.put("unifiedSpeechSettings", UNIFIED_SPEECH_SETTINGS_FIELD);
        map.put("speechRecognitionSettings", SPEECH_RECOGNITION_SETTINGS_FIELD);
        map.put("generativeAISettings", GENERATIVE_AI_SETTINGS_FIELD);
        map.put("speechDetectionSensitivity", SPEECH_DETECTION_SENSITIVITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBotLocaleRequest, T> g) {
        return obj -> g.apply((CreateBotLocaleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateBotLocaleRequest> {
        /**
         * <p>
         * The identifier of the bot to create the locale for.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot to create the locale for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot to create the locale for. This can only be the draft version of the bot.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot to create the locale for. This can only be the draft version of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale that the bot will be used in. The string must match one of the
         * supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For
         * more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
         * languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale that the bot will be used in. The string must match one of
         *        the supported locales. All of the intents, slot types, and slots used in the bot must have the same
         *        locale. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * A description of the bot locale. Use this to help identify the bot locale in lists.
         * </p>
         * 
         * @param description
         *        A description of the bot locale. Use this to help identify the bot locale in lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>,
         * <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents.
         * <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
         * configured for the bot.
         * </p>
         * <p>
         * For example, suppose a bot is configured with the confidence threshold of 0.80 and the
         * <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following
         * confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the
         * <code>RecognizeText</code> operation would be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AMAZON.FallbackIntent
         * </p>
         * </li>
         * <li>
         * <p>
         * IntentA
         * </p>
         * </li>
         * <li>
         * <p>
         * IntentB
         * </p>
         * </li>
         * <li>
         * <p>
         * IntentC
         * </p>
         * </li>
         * </ul>
         * 
         * @param nluIntentConfidenceThreshold
         *        Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>,
         *        <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents.
         *        <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if
         *        they are configured for the bot.</p>
         *        <p>
         *        For example, suppose a bot is configured with the confidence threshold of 0.80 and the
         *        <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following
         *        confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the
         *        <code>RecognizeText</code> operation would be:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AMAZON.FallbackIntent
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IntentA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IntentB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IntentC
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold);

        /**
         * <p>
         * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
         * </p>
         * 
         * @param voiceSettings
         *        The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceSettings(VoiceSettings voiceSettings);

        /**
         * <p>
         * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link VoiceSettings.Builder} avoiding the need
         * to create one manually via {@link VoiceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceSettings(VoiceSettings)}.
         * 
         * @param voiceSettings
         *        a consumer that will call methods on {@link VoiceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceSettings(VoiceSettings)
         */
        default Builder voiceSettings(Consumer<VoiceSettings.Builder> voiceSettings) {
            return voiceSettings(VoiceSettings.builder().applyMutation(voiceSettings).build());
        }

        /**
         * <p>
         * Unified speech settings to configure for the new bot locale.
         * </p>
         * 
         * @param unifiedSpeechSettings
         *        Unified speech settings to configure for the new bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unifiedSpeechSettings(UnifiedSpeechSettings unifiedSpeechSettings);

        /**
         * <p>
         * Unified speech settings to configure for the new bot locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnifiedSpeechSettings.Builder} avoiding
         * the need to create one manually via {@link UnifiedSpeechSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnifiedSpeechSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #unifiedSpeechSettings(UnifiedSpeechSettings)}.
         * 
         * @param unifiedSpeechSettings
         *        a consumer that will call methods on {@link UnifiedSpeechSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unifiedSpeechSettings(UnifiedSpeechSettings)
         */
        default Builder unifiedSpeechSettings(Consumer<UnifiedSpeechSettings.Builder> unifiedSpeechSettings) {
            return unifiedSpeechSettings(UnifiedSpeechSettings.builder().applyMutation(unifiedSpeechSettings).build());
        }

        /**
         * <p>
         * Speech-to-text settings to configure for the new bot locale.
         * </p>
         * 
         * @param speechRecognitionSettings
         *        Speech-to-text settings to configure for the new bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechRecognitionSettings(SpeechRecognitionSettings speechRecognitionSettings);

        /**
         * <p>
         * Speech-to-text settings to configure for the new bot locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpeechRecognitionSettings.Builder}
         * avoiding the need to create one manually via {@link SpeechRecognitionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpeechRecognitionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #speechRecognitionSettings(SpeechRecognitionSettings)}.
         * 
         * @param speechRecognitionSettings
         *        a consumer that will call methods on {@link SpeechRecognitionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #speechRecognitionSettings(SpeechRecognitionSettings)
         */
        default Builder speechRecognitionSettings(Consumer<SpeechRecognitionSettings.Builder> speechRecognitionSettings) {
            return speechRecognitionSettings(SpeechRecognitionSettings.builder().applyMutation(speechRecognitionSettings).build());
        }

        /**
         * Sets the value of the GenerativeAISettings property for this object.
         *
         * @param generativeAISettings
         *        The new value for the GenerativeAISettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeAISettings(GenerativeAISettings generativeAISettings);

        /**
         * Sets the value of the GenerativeAISettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GenerativeAISettings.Builder} avoiding
         * the need to create one manually via {@link GenerativeAISettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerativeAISettings.Builder#build()} is called immediately and
         * its result is passed to {@link #generativeAISettings(GenerativeAISettings)}.
         * 
         * @param generativeAISettings
         *        a consumer that will call methods on {@link GenerativeAISettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeAISettings(GenerativeAISettings)
         */
        default Builder generativeAISettings(Consumer<GenerativeAISettings.Builder> generativeAISettings) {
            return generativeAISettings(GenerativeAISettings.builder().applyMutation(generativeAISettings).build());
        }

        /**
         * <p>
         * The sensitivity level for voice activity detection (VAD) in the bot locale. This setting helps optimize
         * speech recognition accuracy by adjusting how the system responds to background noise during voice
         * interactions.
         * </p>
         * 
         * @param speechDetectionSensitivity
         *        The sensitivity level for voice activity detection (VAD) in the bot locale. This setting helps
         *        optimize speech recognition accuracy by adjusting how the system responds to background noise during
         *        voice interactions.
         * @see SpeechDetectionSensitivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeechDetectionSensitivity
         */
        Builder speechDetectionSensitivity(String speechDetectionSensitivity);

        /**
         * <p>
         * The sensitivity level for voice activity detection (VAD) in the bot locale. This setting helps optimize
         * speech recognition accuracy by adjusting how the system responds to background noise during voice
         * interactions.
         * </p>
         * 
         * @param speechDetectionSensitivity
         *        The sensitivity level for voice activity detection (VAD) in the bot locale. This setting helps
         *        optimize speech recognition accuracy by adjusting how the system responds to background noise during
         *        voice interactions.
         * @see SpeechDetectionSensitivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpeechDetectionSensitivity
         */
        Builder speechDetectionSensitivity(SpeechDetectionSensitivity speechDetectionSensitivity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String description;

        private Double nluIntentConfidenceThreshold;

        private VoiceSettings voiceSettings;

        private UnifiedSpeechSettings unifiedSpeechSettings;

        private SpeechRecognitionSettings speechRecognitionSettings;

        private GenerativeAISettings generativeAISettings;

        private String speechDetectionSensitivity;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotLocaleRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            description(model.description);
            nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            voiceSettings(model.voiceSettings);
            unifiedSpeechSettings(model.unifiedSpeechSettings);
            speechRecognitionSettings(model.speechRecognitionSettings);
            generativeAISettings(model.generativeAISettings);
            speechDetectionSensitivity(model.speechDetectionSensitivity);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return nluIntentConfidenceThreshold;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        @Override
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final VoiceSettings.Builder getVoiceSettings() {
            return voiceSettings != null ? voiceSettings.toBuilder() : null;
        }

        public final void setVoiceSettings(VoiceSettings.BuilderImpl voiceSettings) {
            this.voiceSettings = voiceSettings != null ? voiceSettings.build() : null;
        }

        @Override
        public final Builder voiceSettings(VoiceSettings voiceSettings) {
            this.voiceSettings = voiceSettings;
            return this;
        }

        public final UnifiedSpeechSettings.Builder getUnifiedSpeechSettings() {
            return unifiedSpeechSettings != null ? unifiedSpeechSettings.toBuilder() : null;
        }

        public final void setUnifiedSpeechSettings(UnifiedSpeechSettings.BuilderImpl unifiedSpeechSettings) {
            this.unifiedSpeechSettings = unifiedSpeechSettings != null ? unifiedSpeechSettings.build() : null;
        }

        @Override
        public final Builder unifiedSpeechSettings(UnifiedSpeechSettings unifiedSpeechSettings) {
            this.unifiedSpeechSettings = unifiedSpeechSettings;
            return this;
        }

        public final SpeechRecognitionSettings.Builder getSpeechRecognitionSettings() {
            return speechRecognitionSettings != null ? speechRecognitionSettings.toBuilder() : null;
        }

        public final void setSpeechRecognitionSettings(SpeechRecognitionSettings.BuilderImpl speechRecognitionSettings) {
            this.speechRecognitionSettings = speechRecognitionSettings != null ? speechRecognitionSettings.build() : null;
        }

        @Override
        public final Builder speechRecognitionSettings(SpeechRecognitionSettings speechRecognitionSettings) {
            this.speechRecognitionSettings = speechRecognitionSettings;
            return this;
        }

        public final GenerativeAISettings.Builder getGenerativeAISettings() {
            return generativeAISettings != null ? generativeAISettings.toBuilder() : null;
        }

        public final void setGenerativeAISettings(GenerativeAISettings.BuilderImpl generativeAISettings) {
            this.generativeAISettings = generativeAISettings != null ? generativeAISettings.build() : null;
        }

        @Override
        public final Builder generativeAISettings(GenerativeAISettings generativeAISettings) {
            this.generativeAISettings = generativeAISettings;
            return this;
        }

        public final String getSpeechDetectionSensitivity() {
            return speechDetectionSensitivity;
        }

        public final void setSpeechDetectionSensitivity(String speechDetectionSensitivity) {
            this.speechDetectionSensitivity = speechDetectionSensitivity;
        }

        @Override
        public final Builder speechDetectionSensitivity(String speechDetectionSensitivity) {
            this.speechDetectionSensitivity = speechDetectionSensitivity;
            return this;
        }

        @Override
        public final Builder speechDetectionSensitivity(SpeechDetectionSensitivity speechDetectionSensitivity) {
            this.speechDetectionSensitivity(speechDetectionSensitivity == null ? null : speechDetectionSensitivity.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBotLocaleRequest build() {
            return new CreateBotLocaleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
