/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBotAliasRequest extends LexModelsV2Request implements
        ToCopyableBuilder<CreateBotAliasRequest.Builder, CreateBotAliasRequest> {
    private static final SdkField<String> BOT_ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasName").getter(getter(CreateBotAliasRequest::botAliasName)).setter(setter(Builder::botAliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateBotAliasRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(CreateBotAliasRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<Map<String, BotAliasLocaleSettings>> BOT_ALIAS_LOCALE_SETTINGS_FIELD = SdkField
            .<Map<String, BotAliasLocaleSettings>> builder(MarshallingType.MAP)
            .memberName("botAliasLocaleSettings")
            .getter(getter(CreateBotAliasRequest::botAliasLocaleSettings))
            .setter(setter(Builder::botAliasLocaleSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasLocaleSettings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BotAliasLocaleSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotAliasLocaleSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConversationLogSettings> CONVERSATION_LOG_SETTINGS_FIELD = SdkField
            .<ConversationLogSettings> builder(MarshallingType.SDK_POJO).memberName("conversationLogSettings")
            .getter(getter(CreateBotAliasRequest::conversationLogSettings)).setter(setter(Builder::conversationLogSettings))
            .constructor(ConversationLogSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLogSettings").build())
            .build();

    private static final SdkField<SentimentAnalysisSettings> SENTIMENT_ANALYSIS_SETTINGS_FIELD = SdkField
            .<SentimentAnalysisSettings> builder(MarshallingType.SDK_POJO).memberName("sentimentAnalysisSettings")
            .getter(getter(CreateBotAliasRequest::sentimentAnalysisSettings)).setter(setter(Builder::sentimentAnalysisSettings))
            .constructor(SentimentAnalysisSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentAnalysisSettings").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateBotAliasRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateBotAliasRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_NAME_FIELD,
            DESCRIPTION_FIELD, BOT_VERSION_FIELD, BOT_ALIAS_LOCALE_SETTINGS_FIELD, CONVERSATION_LOG_SETTINGS_FIELD,
            SENTIMENT_ANALYSIS_SETTINGS_FIELD, BOT_ID_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botAliasName;

    private final String description;

    private final String botVersion;

    private final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings;

    private final ConversationLogSettings conversationLogSettings;

    private final SentimentAnalysisSettings sentimentAnalysisSettings;

    private final String botId;

    private final Map<String, String> tags;

    private CreateBotAliasRequest(BuilderImpl builder) {
        super(builder);
        this.botAliasName = builder.botAliasName;
        this.description = builder.description;
        this.botVersion = builder.botVersion;
        this.botAliasLocaleSettings = builder.botAliasLocaleSettings;
        this.conversationLogSettings = builder.conversationLogSettings;
        this.sentimentAnalysisSettings = builder.sentimentAnalysisSettings;
        this.botId = builder.botId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The alias to create. The name must be unique for the bot.
     * </p>
     * 
     * @return The alias to create. The name must be unique for the bot.
     */
    public final String botAliasName() {
        return botAliasName;
    }

    /**
     * <p>
     * A description of the alias. Use this description to help identify the alias.
     * </p>
     * 
     * @return A description of the alias. Use this description to help identify the alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version of the bot that this alias points to. You can use the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html">UpdateBotAlias</a> operation
     * to change the bot version associated with the alias.
     * </p>
     * 
     * @return The version of the bot that this alias points to. You can use the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html">UpdateBotAlias</a>
     *         operation to change the bot version associated with the alias.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotAliasLocaleSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBotAliasLocaleSettings() {
        return botAliasLocaleSettings != null && !(botAliasLocaleSettings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda
     * function to run different functions in different locales.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotAliasLocaleSettings} method.
     * </p>
     * 
     * @return Maps configuration information to a specific locale. You can use this parameter to specify a specific
     *         Lambda function to run different functions in different locales.
     */
    public final Map<String, BotAliasLocaleSettings> botAliasLocaleSettings() {
        return botAliasLocaleSettings;
    }

    /**
     * <p>
     * Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation
     * logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs.
     * Audio logs store audio input in Amazon S3.
     * </p>
     * 
     * @return Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable
     *         conversation logs, text logs store text input, transcripts of audio input, and associated metadata in
     *         Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.
     */
    public final ConversationLogSettings conversationLogSettings() {
        return conversationLogSettings;
    }

    /**
     * Returns the value of the SentimentAnalysisSettings property for this object.
     * 
     * @return The value of the SentimentAnalysisSettings property for this object.
     */
    public final SentimentAnalysisSettings sentimentAnalysisSettings() {
        return sentimentAnalysisSettings;
    }

    /**
     * <p>
     * The unique identifier of the bot that the alias applies to.
     * </p>
     * 
     * @return The unique identifier of the bot that the alias applies to.
     */
    public final String botId() {
        return botId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the
     * <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
     * <code>TagResource</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the
     *         <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
     *         <code>TagResource</code> operation.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotAliasLocaleSettings() ? botAliasLocaleSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conversationLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentAnalysisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotAliasRequest)) {
            return false;
        }
        CreateBotAliasRequest other = (CreateBotAliasRequest) obj;
        return Objects.equals(botAliasName(), other.botAliasName()) && Objects.equals(description(), other.description())
                && Objects.equals(botVersion(), other.botVersion())
                && hasBotAliasLocaleSettings() == other.hasBotAliasLocaleSettings()
                && Objects.equals(botAliasLocaleSettings(), other.botAliasLocaleSettings())
                && Objects.equals(conversationLogSettings(), other.conversationLogSettings())
                && Objects.equals(sentimentAnalysisSettings(), other.sentimentAnalysisSettings())
                && Objects.equals(botId(), other.botId()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBotAliasRequest").add("BotAliasName", botAliasName()).add("Description", description())
                .add("BotVersion", botVersion())
                .add("BotAliasLocaleSettings", hasBotAliasLocaleSettings() ? botAliasLocaleSettings() : null)
                .add("ConversationLogSettings", conversationLogSettings())
                .add("SentimentAnalysisSettings", sentimentAnalysisSettings()).add("BotId", botId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasName":
            return Optional.ofNullable(clazz.cast(botAliasName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "botAliasLocaleSettings":
            return Optional.ofNullable(clazz.cast(botAliasLocaleSettings()));
        case "conversationLogSettings":
            return Optional.ofNullable(clazz.cast(conversationLogSettings()));
        case "sentimentAnalysisSettings":
            return Optional.ofNullable(clazz.cast(sentimentAnalysisSettings()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botAliasName", BOT_ALIAS_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("botAliasLocaleSettings", BOT_ALIAS_LOCALE_SETTINGS_FIELD);
        map.put("conversationLogSettings", CONVERSATION_LOG_SETTINGS_FIELD);
        map.put("sentimentAnalysisSettings", SENTIMENT_ANALYSIS_SETTINGS_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBotAliasRequest, T> g) {
        return obj -> g.apply((CreateBotAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateBotAliasRequest> {
        /**
         * <p>
         * The alias to create. The name must be unique for the bot.
         * </p>
         * 
         * @param botAliasName
         *        The alias to create. The name must be unique for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasName(String botAliasName);

        /**
         * <p>
         * A description of the alias. Use this description to help identify the alias.
         * </p>
         * 
         * @param description
         *        A description of the alias. Use this description to help identify the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the bot that this alias points to. You can use the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html">UpdateBotAlias</a>
         * operation to change the bot version associated with the alias.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that this alias points to. You can use the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html"
         *        >UpdateBotAlias</a> operation to change the bot version associated with the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda
         * function to run different functions in different locales.
         * </p>
         * 
         * @param botAliasLocaleSettings
         *        Maps configuration information to a specific locale. You can use this parameter to specify a specific
         *        Lambda function to run different functions in different locales.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> botAliasLocaleSettings);

        /**
         * <p>
         * Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable
         * conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon
         * CloudWatch Logs. Audio logs store audio input in Amazon S3.
         * </p>
         * 
         * @param conversationLogSettings
         *        Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable
         *        conversation logs, text logs store text input, transcripts of audio input, and associated metadata in
         *        Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationLogSettings(ConversationLogSettings conversationLogSettings);

        /**
         * <p>
         * Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable
         * conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon
         * CloudWatch Logs. Audio logs store audio input in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationLogSettings.Builder} avoiding
         * the need to create one manually via {@link ConversationLogSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationLogSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #conversationLogSettings(ConversationLogSettings)}.
         * 
         * @param conversationLogSettings
         *        a consumer that will call methods on {@link ConversationLogSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationLogSettings(ConversationLogSettings)
         */
        default Builder conversationLogSettings(Consumer<ConversationLogSettings.Builder> conversationLogSettings) {
            return conversationLogSettings(ConversationLogSettings.builder().applyMutation(conversationLogSettings).build());
        }

        /**
         * Sets the value of the SentimentAnalysisSettings property for this object.
         *
         * @param sentimentAnalysisSettings
         *        The new value for the SentimentAnalysisSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentAnalysisSettings(SentimentAnalysisSettings sentimentAnalysisSettings);

        /**
         * Sets the value of the SentimentAnalysisSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SentimentAnalysisSettings.Builder}
         * avoiding the need to create one manually via {@link SentimentAnalysisSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SentimentAnalysisSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #sentimentAnalysisSettings(SentimentAnalysisSettings)}.
         * 
         * @param sentimentAnalysisSettings
         *        a consumer that will call methods on {@link SentimentAnalysisSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentAnalysisSettings(SentimentAnalysisSettings)
         */
        default Builder sentimentAnalysisSettings(Consumer<SentimentAnalysisSettings.Builder> sentimentAnalysisSettings) {
            return sentimentAnalysisSettings(SentimentAnalysisSettings.builder().applyMutation(sentimentAnalysisSettings).build());
        }

        /**
         * <p>
         * The unique identifier of the bot that the alias applies to.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot that the alias applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the
         * <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
         * <code>TagResource</code> operation.
         * </p>
         * 
         * @param tags
         *        A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use
         *        the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the
         *        <code>TagResource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botAliasName;

        private String description;

        private String botVersion;

        private Map<String, BotAliasLocaleSettings> botAliasLocaleSettings = DefaultSdkAutoConstructMap.getInstance();

        private ConversationLogSettings conversationLogSettings;

        private SentimentAnalysisSettings sentimentAnalysisSettings;

        private String botId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotAliasRequest model) {
            super(model);
            botAliasName(model.botAliasName);
            description(model.description);
            botVersion(model.botVersion);
            botAliasLocaleSettings(model.botAliasLocaleSettings);
            conversationLogSettings(model.conversationLogSettings);
            sentimentAnalysisSettings(model.sentimentAnalysisSettings);
            botId(model.botId);
            tags(model.tags);
        }

        public final String getBotAliasName() {
            return botAliasName;
        }

        public final void setBotAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
        }

        @Override
        public final Builder botAliasName(String botAliasName) {
            this.botAliasName = botAliasName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final Map<String, BotAliasLocaleSettings.Builder> getBotAliasLocaleSettings() {
            Map<String, BotAliasLocaleSettings.Builder> result = BotAliasLocaleSettingsMapCopier
                    .copyToBuilder(this.botAliasLocaleSettings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBotAliasLocaleSettings(Map<String, BotAliasLocaleSettings.BuilderImpl> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copyFromBuilder(botAliasLocaleSettings);
        }

        @Override
        public final Builder botAliasLocaleSettings(Map<String, BotAliasLocaleSettings> botAliasLocaleSettings) {
            this.botAliasLocaleSettings = BotAliasLocaleSettingsMapCopier.copy(botAliasLocaleSettings);
            return this;
        }

        public final ConversationLogSettings.Builder getConversationLogSettings() {
            return conversationLogSettings != null ? conversationLogSettings.toBuilder() : null;
        }

        public final void setConversationLogSettings(ConversationLogSettings.BuilderImpl conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings != null ? conversationLogSettings.build() : null;
        }

        @Override
        public final Builder conversationLogSettings(ConversationLogSettings conversationLogSettings) {
            this.conversationLogSettings = conversationLogSettings;
            return this;
        }

        public final SentimentAnalysisSettings.Builder getSentimentAnalysisSettings() {
            return sentimentAnalysisSettings != null ? sentimentAnalysisSettings.toBuilder() : null;
        }

        public final void setSentimentAnalysisSettings(SentimentAnalysisSettings.BuilderImpl sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings != null ? sentimentAnalysisSettings.build() : null;
        }

        @Override
        public final Builder sentimentAnalysisSettings(SentimentAnalysisSettings sentimentAnalysisSettings) {
            this.sentimentAnalysisSettings = sentimentAnalysisSettings;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBotAliasRequest build() {
            return new CreateBotAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
