/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The selection to filter the test set results data at the conversation level.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationLevelTestResultsFilterBy implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversationLevelTestResultsFilterBy.Builder, ConversationLevelTestResultsFilterBy> {
    private static final SdkField<String> END_TO_END_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endToEndResult").getter(getter(ConversationLevelTestResultsFilterBy::endToEndResultAsString))
            .setter(setter(Builder::endToEndResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endToEndResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TO_END_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endToEndResult;

    private ConversationLevelTestResultsFilterBy(BuilderImpl builder) {
        this.endToEndResult = builder.endToEndResult;
    }

    /**
     * <p>
     * The selection of matched or mismatched end-to-end status to filter test set results data at the conversation
     * level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endToEndResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endToEndResultAsString}.
     * </p>
     * 
     * @return The selection of matched or mismatched end-to-end status to filter test set results data at the
     *         conversation level.
     * @see TestResultMatchStatus
     */
    public final TestResultMatchStatus endToEndResult() {
        return TestResultMatchStatus.fromValue(endToEndResult);
    }

    /**
     * <p>
     * The selection of matched or mismatched end-to-end status to filter test set results data at the conversation
     * level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endToEndResult}
     * will return {@link TestResultMatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endToEndResultAsString}.
     * </p>
     * 
     * @return The selection of matched or mismatched end-to-end status to filter test set results data at the
     *         conversation level.
     * @see TestResultMatchStatus
     */
    public final String endToEndResultAsString() {
        return endToEndResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endToEndResultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLevelTestResultsFilterBy)) {
            return false;
        }
        ConversationLevelTestResultsFilterBy other = (ConversationLevelTestResultsFilterBy) obj;
        return Objects.equals(endToEndResultAsString(), other.endToEndResultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversationLevelTestResultsFilterBy").add("EndToEndResult", endToEndResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endToEndResult":
            return Optional.ofNullable(clazz.cast(endToEndResultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endToEndResult", END_TO_END_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConversationLevelTestResultsFilterBy, T> g) {
        return obj -> g.apply((ConversationLevelTestResultsFilterBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationLevelTestResultsFilterBy> {
        /**
         * <p>
         * The selection of matched or mismatched end-to-end status to filter test set results data at the conversation
         * level.
         * </p>
         * 
         * @param endToEndResult
         *        The selection of matched or mismatched end-to-end status to filter test set results data at the
         *        conversation level.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder endToEndResult(String endToEndResult);

        /**
         * <p>
         * The selection of matched or mismatched end-to-end status to filter test set results data at the conversation
         * level.
         * </p>
         * 
         * @param endToEndResult
         *        The selection of matched or mismatched end-to-end status to filter test set results data at the
         *        conversation level.
         * @see TestResultMatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestResultMatchStatus
         */
        Builder endToEndResult(TestResultMatchStatus endToEndResult);
    }

    static final class BuilderImpl implements Builder {
        private String endToEndResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLevelTestResultsFilterBy model) {
            endToEndResult(model.endToEndResult);
        }

        public final String getEndToEndResult() {
            return endToEndResult;
        }

        public final void setEndToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
        }

        @Override
        public final Builder endToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
            return this;
        }

        @Override
        public final Builder endToEndResult(TestResultMatchStatus endToEndResult) {
            this.endToEndResult(endToEndResult == null ? null : endToEndResult.toString());
            return this;
        }

        @Override
        public ConversationLevelTestResultsFilterBy build() {
            return new ConversationLevelTestResultsFilterBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
