/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a list of conditional branches. Branches are evaluated in the order that they are entered in the list. The
 * first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch.
 * The default branch should not have any condition expression. The default branch is executed if no other branch has a
 * matching condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionalSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionalSpecification.Builder, ConditionalSpecification> {
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(ConditionalSpecification::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final SdkField<List<ConditionalBranch>> CONDITIONAL_BRANCHES_FIELD = SdkField
            .<List<ConditionalBranch>> builder(MarshallingType.LIST)
            .memberName("conditionalBranches")
            .getter(getter(ConditionalSpecification::conditionalBranches))
            .setter(setter(Builder::conditionalBranches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionalBranches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConditionalBranch> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConditionalBranch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DefaultConditionalBranch> DEFAULT_BRANCH_FIELD = SdkField
            .<DefaultConditionalBranch> builder(MarshallingType.SDK_POJO).memberName("defaultBranch")
            .getter(getter(ConditionalSpecification::defaultBranch)).setter(setter(Builder::defaultBranch))
            .constructor(DefaultConditionalBranch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBranch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_FIELD,
            CONDITIONAL_BRANCHES_FIELD, DEFAULT_BRANCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean active;

    private final List<ConditionalBranch> conditionalBranches;

    private final DefaultConditionalBranch defaultBranch;

    private ConditionalSpecification(BuilderImpl builder) {
        this.active = builder.active;
        this.conditionalBranches = builder.conditionalBranches;
        this.defaultBranch = builder.defaultBranch;
    }

    /**
     * <p>
     * Determines whether a conditional branch is active. When <code>active</code> is false, the conditions are not
     * evaluated.
     * </p>
     * 
     * @return Determines whether a conditional branch is active. When <code>active</code> is false, the conditions are
     *         not evaluated.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConditionalBranches property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConditionalBranches() {
        return conditionalBranches != null && !(conditionalBranches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditional branches. A conditional branch is made up of a condition, a response and a next step. The
     * response and next step are executed when the condition is true.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditionalBranches} method.
     * </p>
     * 
     * @return A list of conditional branches. A conditional branch is made up of a condition, a response and a next
     *         step. The response and next step are executed when the condition is true.
     */
    public final List<ConditionalBranch> conditionalBranches() {
        return conditionalBranches;
    }

    /**
     * <p>
     * The conditional branch that should be followed when the conditions for other branches are not satisfied. A
     * conditional branch is made up of a condition, a response and a next step.
     * </p>
     * 
     * @return The conditional branch that should be followed when the conditions for other branches are not satisfied.
     *         A conditional branch is made up of a condition, a response and a next step.
     */
    public final DefaultConditionalBranch defaultBranch() {
        return defaultBranch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditionalBranches() ? conditionalBranches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultBranch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalSpecification)) {
            return false;
        }
        ConditionalSpecification other = (ConditionalSpecification) obj;
        return Objects.equals(active(), other.active()) && hasConditionalBranches() == other.hasConditionalBranches()
                && Objects.equals(conditionalBranches(), other.conditionalBranches())
                && Objects.equals(defaultBranch(), other.defaultBranch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionalSpecification").add("Active", active())
                .add("ConditionalBranches", hasConditionalBranches() ? conditionalBranches() : null)
                .add("DefaultBranch", defaultBranch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        case "conditionalBranches":
            return Optional.ofNullable(clazz.cast(conditionalBranches()));
        case "defaultBranch":
            return Optional.ofNullable(clazz.cast(defaultBranch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("active", ACTIVE_FIELD);
        map.put("conditionalBranches", CONDITIONAL_BRANCHES_FIELD);
        map.put("defaultBranch", DEFAULT_BRANCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionalSpecification, T> g) {
        return obj -> g.apply((ConditionalSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionalSpecification> {
        /**
         * <p>
         * Determines whether a conditional branch is active. When <code>active</code> is false, the conditions are not
         * evaluated.
         * </p>
         * 
         * @param active
         *        Determines whether a conditional branch is active. When <code>active</code> is false, the conditions
         *        are not evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * A list of conditional branches. A conditional branch is made up of a condition, a response and a next step.
         * The response and next step are executed when the condition is true.
         * </p>
         * 
         * @param conditionalBranches
         *        A list of conditional branches. A conditional branch is made up of a condition, a response and a next
         *        step. The response and next step are executed when the condition is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalBranches(Collection<ConditionalBranch> conditionalBranches);

        /**
         * <p>
         * A list of conditional branches. A conditional branch is made up of a condition, a response and a next step.
         * The response and next step are executed when the condition is true.
         * </p>
         * 
         * @param conditionalBranches
         *        A list of conditional branches. A conditional branch is made up of a condition, a response and a next
         *        step. The response and next step are executed when the condition is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionalBranches(ConditionalBranch... conditionalBranches);

        /**
         * <p>
         * A list of conditional branches. A conditional branch is made up of a condition, a response and a next step.
         * The response and next step are executed when the condition is true.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch.Builder#build()} is called
         * immediately and its result is passed to {@link #conditionalBranches(List<ConditionalBranch>)}.
         * 
         * @param conditionalBranches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ConditionalBranch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionalBranches(java.util.Collection<ConditionalBranch>)
         */
        Builder conditionalBranches(Consumer<ConditionalBranch.Builder>... conditionalBranches);

        /**
         * <p>
         * The conditional branch that should be followed when the conditions for other branches are not satisfied. A
         * conditional branch is made up of a condition, a response and a next step.
         * </p>
         * 
         * @param defaultBranch
         *        The conditional branch that should be followed when the conditions for other branches are not
         *        satisfied. A conditional branch is made up of a condition, a response and a next step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultBranch(DefaultConditionalBranch defaultBranch);

        /**
         * <p>
         * The conditional branch that should be followed when the conditions for other branches are not satisfied. A
         * conditional branch is made up of a condition, a response and a next step.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultConditionalBranch.Builder}
         * avoiding the need to create one manually via {@link DefaultConditionalBranch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultConditionalBranch.Builder#build()} is called immediately
         * and its result is passed to {@link #defaultBranch(DefaultConditionalBranch)}.
         * 
         * @param defaultBranch
         *        a consumer that will call methods on {@link DefaultConditionalBranch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultBranch(DefaultConditionalBranch)
         */
        default Builder defaultBranch(Consumer<DefaultConditionalBranch.Builder> defaultBranch) {
            return defaultBranch(DefaultConditionalBranch.builder().applyMutation(defaultBranch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean active;

        private List<ConditionalBranch> conditionalBranches = DefaultSdkAutoConstructList.getInstance();

        private DefaultConditionalBranch defaultBranch;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalSpecification model) {
            active(model.active);
            conditionalBranches(model.conditionalBranches);
            defaultBranch(model.defaultBranch);
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final List<ConditionalBranch.Builder> getConditionalBranches() {
            List<ConditionalBranch.Builder> result = ConditionalBranchesCopier.copyToBuilder(this.conditionalBranches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditionalBranches(Collection<ConditionalBranch.BuilderImpl> conditionalBranches) {
            this.conditionalBranches = ConditionalBranchesCopier.copyFromBuilder(conditionalBranches);
        }

        @Override
        public final Builder conditionalBranches(Collection<ConditionalBranch> conditionalBranches) {
            this.conditionalBranches = ConditionalBranchesCopier.copy(conditionalBranches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalBranches(ConditionalBranch... conditionalBranches) {
            conditionalBranches(Arrays.asList(conditionalBranches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalBranches(Consumer<ConditionalBranch.Builder>... conditionalBranches) {
            conditionalBranches(Stream.of(conditionalBranches).map(c -> ConditionalBranch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DefaultConditionalBranch.Builder getDefaultBranch() {
            return defaultBranch != null ? defaultBranch.toBuilder() : null;
        }

        public final void setDefaultBranch(DefaultConditionalBranch.BuilderImpl defaultBranch) {
            this.defaultBranch = defaultBranch != null ? defaultBranch.build() : null;
        }

        @Override
        public final Builder defaultBranch(DefaultConditionalBranch defaultBranch) {
            this.defaultBranch = defaultBranch;
            return this;
        }

        @Override
        public ConditionalSpecification build() {
            return new ConditionalSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
