/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A composite slot is a combination of two or more slots that capture multiple pieces of information in a single user
 * input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompositeSlotTypeSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<CompositeSlotTypeSetting.Builder, CompositeSlotTypeSetting> {
    private static final SdkField<List<SubSlotTypeComposition>> SUB_SLOTS_FIELD = SdkField
            .<List<SubSlotTypeComposition>> builder(MarshallingType.LIST)
            .memberName("subSlots")
            .getter(getter(CompositeSlotTypeSetting::subSlots))
            .setter(setter(Builder::subSlots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSlots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubSlotTypeComposition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubSlotTypeComposition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUB_SLOTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SubSlotTypeComposition> subSlots;

    private CompositeSlotTypeSetting(BuilderImpl builder) {
        this.subSlots = builder.subSlots;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubSlots property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubSlots() {
        return subSlots != null && !(subSlots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Subslots in the composite slot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubSlots} method.
     * </p>
     * 
     * @return Subslots in the composite slot.
     */
    public final List<SubSlotTypeComposition> subSlots() {
        return subSlots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubSlots() ? subSlots() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeSlotTypeSetting)) {
            return false;
        }
        CompositeSlotTypeSetting other = (CompositeSlotTypeSetting) obj;
        return hasSubSlots() == other.hasSubSlots() && Objects.equals(subSlots(), other.subSlots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompositeSlotTypeSetting").add("SubSlots", hasSubSlots() ? subSlots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subSlots":
            return Optional.ofNullable(clazz.cast(subSlots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("subSlots", SUB_SLOTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompositeSlotTypeSetting, T> g) {
        return obj -> g.apply((CompositeSlotTypeSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompositeSlotTypeSetting> {
        /**
         * <p>
         * Subslots in the composite slot.
         * </p>
         * 
         * @param subSlots
         *        Subslots in the composite slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSlots(Collection<SubSlotTypeComposition> subSlots);

        /**
         * <p>
         * Subslots in the composite slot.
         * </p>
         * 
         * @param subSlots
         *        Subslots in the composite slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subSlots(SubSlotTypeComposition... subSlots);

        /**
         * <p>
         * Subslots in the composite slot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SubSlotTypeComposition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SubSlotTypeComposition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SubSlotTypeComposition.Builder#build()} is called
         * immediately and its result is passed to {@link #subSlots(List<SubSlotTypeComposition>)}.
         * 
         * @param subSlots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SubSlotTypeComposition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subSlots(java.util.Collection<SubSlotTypeComposition>)
         */
        Builder subSlots(Consumer<SubSlotTypeComposition.Builder>... subSlots);
    }

    static final class BuilderImpl implements Builder {
        private List<SubSlotTypeComposition> subSlots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeSlotTypeSetting model) {
            subSlots(model.subSlots);
        }

        public final List<SubSlotTypeComposition.Builder> getSubSlots() {
            List<SubSlotTypeComposition.Builder> result = SubSlotTypeListCopier.copyToBuilder(this.subSlots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubSlots(Collection<SubSlotTypeComposition.BuilderImpl> subSlots) {
            this.subSlots = SubSlotTypeListCopier.copyFromBuilder(subSlots);
        }

        @Override
        public final Builder subSlots(Collection<SubSlotTypeComposition> subSlots) {
            this.subSlots = SubSlotTypeListCopier.copy(subSlots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subSlots(SubSlotTypeComposition... subSlots) {
            subSlots(Arrays.asList(subSlots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subSlots(Consumer<SubSlotTypeComposition.Builder>... subSlots) {
            subSlots(Stream.of(subSlots).map(c -> SubSlotTypeComposition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CompositeSlotTypeSetting build() {
            return new CompositeSlotTypeSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
