/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about all the aliases replication statuses applicable for global resiliency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotAliasReplicaSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BotAliasReplicaSummary.Builder, BotAliasReplicaSummary> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(BotAliasReplicaSummary::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> BOT_ALIAS_REPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasReplicationStatus").getter(getter(BotAliasReplicaSummary::botAliasReplicationStatusAsString))
            .setter(setter(Builder::botAliasReplicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasReplicationStatus").build())
            .build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(BotAliasReplicaSummary::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(BotAliasReplicaSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(BotAliasReplicaSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(BotAliasReplicaSummary::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD,
            BOT_ALIAS_REPLICATION_STATUS_FIELD, BOT_VERSION_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD,
            FAILURE_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String botAliasId;

    private final String botAliasReplicationStatus;

    private final String botVersion;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final List<String> failureReasons;

    private BotAliasReplicaSummary(BuilderImpl builder) {
        this.botAliasId = builder.botAliasId;
        this.botAliasReplicationStatus = builder.botAliasReplicationStatus;
        this.botVersion = builder.botVersion;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReasons = builder.failureReasons;
    }

    /**
     * <p>
     * The bot alias ID for all the alias bot replications.
     * </p>
     * 
     * @return The bot alias ID for all the alias bot replications.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The replication statuses for all the alias bot replications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #botAliasReplicationStatus} will return {@link BotAliasReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #botAliasReplicationStatusAsString}.
     * </p>
     * 
     * @return The replication statuses for all the alias bot replications.
     * @see BotAliasReplicationStatus
     */
    public final BotAliasReplicationStatus botAliasReplicationStatus() {
        return BotAliasReplicationStatus.fromValue(botAliasReplicationStatus);
    }

    /**
     * <p>
     * The replication statuses for all the alias bot replications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #botAliasReplicationStatus} will return {@link BotAliasReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #botAliasReplicationStatusAsString}.
     * </p>
     * 
     * @return The replication statuses for all the alias bot replications.
     * @see BotAliasReplicationStatus
     */
    public final String botAliasReplicationStatusAsString() {
        return botAliasReplicationStatus;
    }

    /**
     * <p>
     * The bot version for all the alias bot replications.
     * </p>
     * 
     * @return The bot version for all the alias bot replications.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The creation time and date for all the alias bot replications.
     * </p>
     * 
     * @return The creation time and date for all the alias bot replications.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The last time and date updated for all the alias bot replications.
     * </p>
     * 
     * @return The last time and date updated for all the alias bot replications.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reasons for failure for the aliases bot replications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return The reasons for failure for the aliases bot replications.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasReplicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotAliasReplicaSummary)) {
            return false;
        }
        BotAliasReplicaSummary other = (BotAliasReplicaSummary) obj;
        return Objects.equals(botAliasId(), other.botAliasId())
                && Objects.equals(botAliasReplicationStatusAsString(), other.botAliasReplicationStatusAsString())
                && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotAliasReplicaSummary").add("BotAliasId", botAliasId())
                .add("BotAliasReplicationStatus", botAliasReplicationStatusAsString()).add("BotVersion", botVersion())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "botAliasReplicationStatus":
            return Optional.ofNullable(clazz.cast(botAliasReplicationStatusAsString()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botAliasId", BOT_ALIAS_ID_FIELD);
        map.put("botAliasReplicationStatus", BOT_ALIAS_REPLICATION_STATUS_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BotAliasReplicaSummary, T> g) {
        return obj -> g.apply((BotAliasReplicaSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotAliasReplicaSummary> {
        /**
         * <p>
         * The bot alias ID for all the alias bot replications.
         * </p>
         * 
         * @param botAliasId
         *        The bot alias ID for all the alias bot replications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The replication statuses for all the alias bot replications.
         * </p>
         * 
         * @param botAliasReplicationStatus
         *        The replication statuses for all the alias bot replications.
         * @see BotAliasReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasReplicationStatus
         */
        Builder botAliasReplicationStatus(String botAliasReplicationStatus);

        /**
         * <p>
         * The replication statuses for all the alias bot replications.
         * </p>
         * 
         * @param botAliasReplicationStatus
         *        The replication statuses for all the alias bot replications.
         * @see BotAliasReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotAliasReplicationStatus
         */
        Builder botAliasReplicationStatus(BotAliasReplicationStatus botAliasReplicationStatus);

        /**
         * <p>
         * The bot version for all the alias bot replications.
         * </p>
         * 
         * @param botVersion
         *        The bot version for all the alias bot replications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The creation time and date for all the alias bot replications.
         * </p>
         * 
         * @param creationDateTime
         *        The creation time and date for all the alias bot replications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The last time and date updated for all the alias bot replications.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The last time and date updated for all the alias bot replications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The reasons for failure for the aliases bot replications.
         * </p>
         * 
         * @param failureReasons
         *        The reasons for failure for the aliases bot replications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * The reasons for failure for the aliases bot replications.
         * </p>
         * 
         * @param failureReasons
         *        The reasons for failure for the aliases bot replications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);
    }

    static final class BuilderImpl implements Builder {
        private String botAliasId;

        private String botAliasReplicationStatus;

        private String botVersion;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BotAliasReplicaSummary model) {
            botAliasId(model.botAliasId);
            botAliasReplicationStatus(model.botAliasReplicationStatus);
            botVersion(model.botVersion);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            failureReasons(model.failureReasons);
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotAliasReplicationStatus() {
            return botAliasReplicationStatus;
        }

        public final void setBotAliasReplicationStatus(String botAliasReplicationStatus) {
            this.botAliasReplicationStatus = botAliasReplicationStatus;
        }

        @Override
        public final Builder botAliasReplicationStatus(String botAliasReplicationStatus) {
            this.botAliasReplicationStatus = botAliasReplicationStatus;
            return this;
        }

        @Override
        public final Builder botAliasReplicationStatus(BotAliasReplicationStatus botAliasReplicationStatus) {
            this.botAliasReplicationStatus(botAliasReplicationStatus == null ? null : botAliasReplicationStatus.toString());
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        @Override
        public BotAliasReplicaSummary build() {
            return new BotAliasReplicaSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
