/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the audio input specifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioSpecification.Builder, AudioSpecification> {
    private static final SdkField<Integer> MAX_LENGTH_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxLengthMs").getter(getter(AudioSpecification::maxLengthMs)).setter(setter(Builder::maxLengthMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLengthMs").build()).build();

    private static final SdkField<Integer> END_TIMEOUT_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endTimeoutMs").getter(getter(AudioSpecification::endTimeoutMs)).setter(setter(Builder::endTimeoutMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeoutMs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_LENGTH_MS_FIELD,
            END_TIMEOUT_MS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxLengthMs;

    private final Integer endTimeoutMs;

    private AudioSpecification(BuilderImpl builder) {
        this.maxLengthMs = builder.maxLengthMs;
        this.endTimeoutMs = builder.endTimeoutMs;
    }

    /**
     * <p>
     * Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to application.
     * </p>
     * 
     * @return Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to
     *         application.
     */
    public final Integer maxLengthMs() {
        return maxLengthMs;
    }

    /**
     * <p>
     * Time for which a bot waits after the customer stops speaking to assume the utterance is finished.
     * </p>
     * 
     * @return Time for which a bot waits after the customer stops speaking to assume the utterance is finished.
     */
    public final Integer endTimeoutMs() {
        return endTimeoutMs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxLengthMs());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeoutMs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSpecification)) {
            return false;
        }
        AudioSpecification other = (AudioSpecification) obj;
        return Objects.equals(maxLengthMs(), other.maxLengthMs()) && Objects.equals(endTimeoutMs(), other.endTimeoutMs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioSpecification").add("MaxLengthMs", maxLengthMs()).add("EndTimeoutMs", endTimeoutMs())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxLengthMs":
            return Optional.ofNullable(clazz.cast(maxLengthMs()));
        case "endTimeoutMs":
            return Optional.ofNullable(clazz.cast(endTimeoutMs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxLengthMs", MAX_LENGTH_MS_FIELD);
        map.put("endTimeoutMs", END_TIMEOUT_MS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioSpecification, T> g) {
        return obj -> g.apply((AudioSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioSpecification> {
        /**
         * <p>
         * Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to
         * application.
         * </p>
         * 
         * @param maxLengthMs
         *        Time for how long Amazon Lex waits before speech input is truncated and the speech is returned to
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLengthMs(Integer maxLengthMs);

        /**
         * <p>
         * Time for which a bot waits after the customer stops speaking to assume the utterance is finished.
         * </p>
         * 
         * @param endTimeoutMs
         *        Time for which a bot waits after the customer stops speaking to assume the utterance is finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeoutMs(Integer endTimeoutMs);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxLengthMs;

        private Integer endTimeoutMs;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSpecification model) {
            maxLengthMs(model.maxLengthMs);
            endTimeoutMs(model.endTimeoutMs);
        }

        public final Integer getMaxLengthMs() {
            return maxLengthMs;
        }

        public final void setMaxLengthMs(Integer maxLengthMs) {
            this.maxLengthMs = maxLengthMs;
        }

        @Override
        public final Builder maxLengthMs(Integer maxLengthMs) {
            this.maxLengthMs = maxLengthMs;
            return this;
        }

        public final Integer getEndTimeoutMs() {
            return endTimeoutMs;
        }

        public final void setEndTimeoutMs(Integer endTimeoutMs) {
            this.endTimeoutMs = endTimeoutMs;
        }

        @Override
        public final Builder endTimeoutMs(Integer endTimeoutMs) {
            this.endTimeoutMs = endTimeoutMs;
            return this;
        }

        @Override
        public AudioSpecification build() {
            return new AudioSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
