/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing the intent that the bot mapped the utterance to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsUtteranceAttributeResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsUtteranceAttributeResult.Builder, AnalyticsUtteranceAttributeResult> {
    private static final SdkField<String> LAST_USED_INTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUsedIntent").getter(getter(AnalyticsUtteranceAttributeResult::lastUsedIntent))
            .setter(setter(Builder::lastUsedIntent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUsedIntent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_USED_INTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lastUsedIntent;

    private AnalyticsUtteranceAttributeResult(BuilderImpl builder) {
        this.lastUsedIntent = builder.lastUsedIntent;
    }

    /**
     * <p>
     * The intent that the bot mapped the utterance to.
     * </p>
     * 
     * @return The intent that the bot mapped the utterance to.
     */
    public final String lastUsedIntent() {
        return lastUsedIntent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastUsedIntent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsUtteranceAttributeResult)) {
            return false;
        }
        AnalyticsUtteranceAttributeResult other = (AnalyticsUtteranceAttributeResult) obj;
        return Objects.equals(lastUsedIntent(), other.lastUsedIntent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsUtteranceAttributeResult").add("LastUsedIntent", lastUsedIntent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastUsedIntent":
            return Optional.ofNullable(clazz.cast(lastUsedIntent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lastUsedIntent", LAST_USED_INTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsUtteranceAttributeResult, T> g) {
        return obj -> g.apply((AnalyticsUtteranceAttributeResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsUtteranceAttributeResult> {
        /**
         * <p>
         * The intent that the bot mapped the utterance to.
         * </p>
         * 
         * @param lastUsedIntent
         *        The intent that the bot mapped the utterance to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUsedIntent(String lastUsedIntent);
    }

    static final class BuilderImpl implements Builder {
        private String lastUsedIntent;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsUtteranceAttributeResult model) {
            lastUsedIntent(model.lastUsedIntent);
        }

        public final String getLastUsedIntent() {
            return lastUsedIntent;
        }

        public final void setLastUsedIntent(String lastUsedIntent) {
            this.lastUsedIntent = lastUsedIntent;
        }

        @Override
        public final Builder lastUsedIntent(String lastUsedIntent) {
            this.lastUsedIntent = lastUsedIntent;
            return this;
        }

        @Override
        public AnalyticsUtteranceAttributeResult build() {
            return new AnalyticsUtteranceAttributeResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
