/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing information about the requested path.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsIntentNodeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsIntentNodeSummary.Builder, AnalyticsIntentNodeSummary> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(AnalyticsIntentNodeSummary::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<String> INTENT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentPath").getter(getter(AnalyticsIntentNodeSummary::intentPath)).setter(setter(Builder::intentPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentPath").build()).build();

    private static final SdkField<Integer> INTENT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("intentCount").getter(getter(AnalyticsIntentNodeSummary::intentCount))
            .setter(setter(Builder::intentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentCount").build()).build();

    private static final SdkField<Integer> INTENT_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("intentLevel").getter(getter(AnalyticsIntentNodeSummary::intentLevel))
            .setter(setter(Builder::intentLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentLevel").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeType").getter(getter(AnalyticsIntentNodeSummary::nodeTypeAsString))
            .setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD,
            INTENT_PATH_FIELD, INTENT_COUNT_FIELD, INTENT_LEVEL_FIELD, NODE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String intentName;

    private final String intentPath;

    private final Integer intentCount;

    private final Integer intentLevel;

    private final String nodeType;

    private AnalyticsIntentNodeSummary(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.intentPath = builder.intentPath;
        this.intentCount = builder.intentCount;
        this.intentLevel = builder.intentLevel;
        this.nodeType = builder.nodeType;
    }

    /**
     * <p>
     * The name of the intent at the end of the requested path.
     * </p>
     * 
     * @return The name of the intent at the end of the requested path.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * The path.
     * </p>
     * 
     * @return The path.
     */
    public final String intentPath() {
        return intentPath;
    }

    /**
     * <p>
     * The total number of sessions that follow the given path to the given intent.
     * </p>
     * 
     * @return The total number of sessions that follow the given path to the given intent.
     */
    public final Integer intentCount() {
        return intentCount;
    }

    /**
     * <p>
     * The number of intents up to and including the requested path.
     * </p>
     * 
     * @return The number of intents up to and including the requested path.
     */
    public final Integer intentLevel() {
        return intentLevel;
    }

    /**
     * <p>
     * Specifies whether the node is the end of a path (<code>Exit</code>) or not (<code>Inner</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link AnalyticsNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the node is the end of a path (<code>Exit</code>) or not (<code>Inner</code>).
     * @see AnalyticsNodeType
     */
    public final AnalyticsNodeType nodeType() {
        return AnalyticsNodeType.fromValue(nodeType);
    }

    /**
     * <p>
     * Specifies whether the node is the end of a path (<code>Exit</code>) or not (<code>Inner</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link AnalyticsNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the node is the end of a path (<code>Exit</code>) or not (<code>Inner</code>).
     * @see AnalyticsNodeType
     */
    public final String nodeTypeAsString() {
        return nodeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(intentPath());
        hashCode = 31 * hashCode + Objects.hashCode(intentCount());
        hashCode = 31 * hashCode + Objects.hashCode(intentLevel());
        hashCode = 31 * hashCode + Objects.hashCode(nodeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsIntentNodeSummary)) {
            return false;
        }
        AnalyticsIntentNodeSummary other = (AnalyticsIntentNodeSummary) obj;
        return Objects.equals(intentName(), other.intentName()) && Objects.equals(intentPath(), other.intentPath())
                && Objects.equals(intentCount(), other.intentCount()) && Objects.equals(intentLevel(), other.intentLevel())
                && Objects.equals(nodeTypeAsString(), other.nodeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsIntentNodeSummary").add("IntentName", intentName()).add("IntentPath", intentPath())
                .add("IntentCount", intentCount()).add("IntentLevel", intentLevel()).add("NodeType", nodeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "intentPath":
            return Optional.ofNullable(clazz.cast(intentPath()));
        case "intentCount":
            return Optional.ofNullable(clazz.cast(intentCount()));
        case "intentLevel":
            return Optional.ofNullable(clazz.cast(intentLevel()));
        case "nodeType":
            return Optional.ofNullable(clazz.cast(nodeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("intentName", INTENT_NAME_FIELD);
        map.put("intentPath", INTENT_PATH_FIELD);
        map.put("intentCount", INTENT_COUNT_FIELD);
        map.put("intentLevel", INTENT_LEVEL_FIELD);
        map.put("nodeType", NODE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsIntentNodeSummary, T> g) {
        return obj -> g.apply((AnalyticsIntentNodeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsIntentNodeSummary> {
        /**
         * <p>
         * The name of the intent at the end of the requested path.
         * </p>
         * 
         * @param intentName
         *        The name of the intent at the end of the requested path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * The path.
         * </p>
         * 
         * @param intentPath
         *        The path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentPath(String intentPath);

        /**
         * <p>
         * The total number of sessions that follow the given path to the given intent.
         * </p>
         * 
         * @param intentCount
         *        The total number of sessions that follow the given path to the given intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentCount(Integer intentCount);

        /**
         * <p>
         * The number of intents up to and including the requested path.
         * </p>
         * 
         * @param intentLevel
         *        The number of intents up to and including the requested path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentLevel(Integer intentLevel);

        /**
         * <p>
         * Specifies whether the node is the end of a path (<code>Exit</code>) or not (<code>Inner</code>).
         * </p>
         * 
         * @param nodeType
         *        Specifies whether the node is the end of a path (<code>Exit</code>) or not (<code>Inner</code>).
         * @see AnalyticsNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsNodeType
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * Specifies whether the node is the end of a path (<code>Exit</code>) or not (<code>Inner</code>).
         * </p>
         * 
         * @param nodeType
         *        Specifies whether the node is the end of a path (<code>Exit</code>) or not (<code>Inner</code>).
         * @see AnalyticsNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsNodeType
         */
        Builder nodeType(AnalyticsNodeType nodeType);
    }

    static final class BuilderImpl implements Builder {
        private String intentName;

        private String intentPath;

        private Integer intentCount;

        private Integer intentLevel;

        private String nodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsIntentNodeSummary model) {
            intentName(model.intentName);
            intentPath(model.intentPath);
            intentCount(model.intentCount);
            intentLevel(model.intentLevel);
            nodeType(model.nodeType);
        }

        public final String getIntentName() {
            return intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getIntentPath() {
            return intentPath;
        }

        public final void setIntentPath(String intentPath) {
            this.intentPath = intentPath;
        }

        @Override
        public final Builder intentPath(String intentPath) {
            this.intentPath = intentPath;
            return this;
        }

        public final Integer getIntentCount() {
            return intentCount;
        }

        public final void setIntentCount(Integer intentCount) {
            this.intentCount = intentCount;
        }

        @Override
        public final Builder intentCount(Integer intentCount) {
            this.intentCount = intentCount;
            return this;
        }

        public final Integer getIntentLevel() {
            return intentLevel;
        }

        public final void setIntentLevel(Integer intentLevel) {
            this.intentLevel = intentLevel;
        }

        @Override
        public final Builder intentLevel(Integer intentLevel) {
            this.intentLevel = intentLevel;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(AnalyticsNodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        @Override
        public AnalyticsIntentNodeSummary build() {
            return new AnalyticsIntentNodeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
