/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing the criterion by which to bin the results and the value that defines that bin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsBinKey implements SdkPojo, Serializable, ToCopyableBuilder<AnalyticsBinKey.Builder, AnalyticsBinKey> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AnalyticsBinKey::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("value")
            .getter(getter(AnalyticsBinKey::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Long value;

    private AnalyticsBinKey(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The criterion by which to bin the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsBinByName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The criterion by which to bin the results.
     * @see AnalyticsBinByName
     */
    public final AnalyticsBinByName name() {
        return AnalyticsBinByName.fromValue(name);
    }

    /**
     * <p>
     * The criterion by which to bin the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsBinByName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The criterion by which to bin the results.
     * @see AnalyticsBinByName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The value of the criterion that defines the bin.
     * </p>
     * 
     * @return The value of the criterion that defines the bin.
     */
    public final Long value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsBinKey)) {
            return false;
        }
        AnalyticsBinKey other = (AnalyticsBinKey) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsBinKey").add("Name", nameAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsBinKey, T> g) {
        return obj -> g.apply((AnalyticsBinKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsBinKey> {
        /**
         * <p>
         * The criterion by which to bin the results.
         * </p>
         * 
         * @param name
         *        The criterion by which to bin the results.
         * @see AnalyticsBinByName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsBinByName
         */
        Builder name(String name);

        /**
         * <p>
         * The criterion by which to bin the results.
         * </p>
         * 
         * @param name
         *        The criterion by which to bin the results.
         * @see AnalyticsBinByName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsBinByName
         */
        Builder name(AnalyticsBinByName name);

        /**
         * <p>
         * The value of the criterion that defines the bin.
         * </p>
         * 
         * @param value
         *        The value of the criterion that defines the bin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Long value;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsBinKey model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AnalyticsBinByName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Long getValue() {
            return value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        @Override
        public AnalyticsBinKey build() {
            return new AnalyticsBinKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
