/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the agent turn in a test set execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentTurnResult implements SdkPojo, Serializable, ToCopyableBuilder<AgentTurnResult.Builder, AgentTurnResult> {
    private static final SdkField<String> EXPECTED_AGENT_PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedAgentPrompt").getter(getter(AgentTurnResult::expectedAgentPrompt))
            .setter(setter(Builder::expectedAgentPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedAgentPrompt").build())
            .build();

    private static final SdkField<String> ACTUAL_AGENT_PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actualAgentPrompt").getter(getter(AgentTurnResult::actualAgentPrompt))
            .setter(setter(Builder::actualAgentPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualAgentPrompt").build()).build();

    private static final SdkField<ExecutionErrorDetails> ERROR_DETAILS_FIELD = SdkField
            .<ExecutionErrorDetails> builder(MarshallingType.SDK_POJO).memberName("errorDetails")
            .getter(getter(AgentTurnResult::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(ExecutionErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()).build();

    private static final SdkField<String> ACTUAL_ELICITED_SLOT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actualElicitedSlot").getter(getter(AgentTurnResult::actualElicitedSlot))
            .setter(setter(Builder::actualElicitedSlot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualElicitedSlot").build())
            .build();

    private static final SdkField<String> ACTUAL_INTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actualIntent").getter(getter(AgentTurnResult::actualIntent)).setter(setter(Builder::actualIntent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualIntent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPECTED_AGENT_PROMPT_FIELD,
            ACTUAL_AGENT_PROMPT_FIELD, ERROR_DETAILS_FIELD, ACTUAL_ELICITED_SLOT_FIELD, ACTUAL_INTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expectedAgentPrompt;

    private final String actualAgentPrompt;

    private final ExecutionErrorDetails errorDetails;

    private final String actualElicitedSlot;

    private final String actualIntent;

    private AgentTurnResult(BuilderImpl builder) {
        this.expectedAgentPrompt = builder.expectedAgentPrompt;
        this.actualAgentPrompt = builder.actualAgentPrompt;
        this.errorDetails = builder.errorDetails;
        this.actualElicitedSlot = builder.actualElicitedSlot;
        this.actualIntent = builder.actualIntent;
    }

    /**
     * <p>
     * The expected agent prompt for the agent turn in a test set execution.
     * </p>
     * 
     * @return The expected agent prompt for the agent turn in a test set execution.
     */
    public final String expectedAgentPrompt() {
        return expectedAgentPrompt;
    }

    /**
     * <p>
     * The actual agent prompt for the agent turn in a test set execution.
     * </p>
     * 
     * @return The actual agent prompt for the agent turn in a test set execution.
     */
    public final String actualAgentPrompt() {
        return actualAgentPrompt;
    }

    /**
     * Returns the value of the ErrorDetails property for this object.
     * 
     * @return The value of the ErrorDetails property for this object.
     */
    public final ExecutionErrorDetails errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * The actual elicited slot for the agent turn in a test set execution.
     * </p>
     * 
     * @return The actual elicited slot for the agent turn in a test set execution.
     */
    public final String actualElicitedSlot() {
        return actualElicitedSlot;
    }

    /**
     * <p>
     * The actual intent for the agent turn in a test set execution.
     * </p>
     * 
     * @return The actual intent for the agent turn in a test set execution.
     */
    public final String actualIntent() {
        return actualIntent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expectedAgentPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(actualAgentPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(actualElicitedSlot());
        hashCode = 31 * hashCode + Objects.hashCode(actualIntent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentTurnResult)) {
            return false;
        }
        AgentTurnResult other = (AgentTurnResult) obj;
        return Objects.equals(expectedAgentPrompt(), other.expectedAgentPrompt())
                && Objects.equals(actualAgentPrompt(), other.actualAgentPrompt())
                && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(actualElicitedSlot(), other.actualElicitedSlot())
                && Objects.equals(actualIntent(), other.actualIntent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentTurnResult").add("ExpectedAgentPrompt", expectedAgentPrompt())
                .add("ActualAgentPrompt", actualAgentPrompt()).add("ErrorDetails", errorDetails())
                .add("ActualElicitedSlot", actualElicitedSlot()).add("ActualIntent", actualIntent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expectedAgentPrompt":
            return Optional.ofNullable(clazz.cast(expectedAgentPrompt()));
        case "actualAgentPrompt":
            return Optional.ofNullable(clazz.cast(actualAgentPrompt()));
        case "errorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "actualElicitedSlot":
            return Optional.ofNullable(clazz.cast(actualElicitedSlot()));
        case "actualIntent":
            return Optional.ofNullable(clazz.cast(actualIntent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("expectedAgentPrompt", EXPECTED_AGENT_PROMPT_FIELD);
        map.put("actualAgentPrompt", ACTUAL_AGENT_PROMPT_FIELD);
        map.put("errorDetails", ERROR_DETAILS_FIELD);
        map.put("actualElicitedSlot", ACTUAL_ELICITED_SLOT_FIELD);
        map.put("actualIntent", ACTUAL_INTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentTurnResult, T> g) {
        return obj -> g.apply((AgentTurnResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentTurnResult> {
        /**
         * <p>
         * The expected agent prompt for the agent turn in a test set execution.
         * </p>
         * 
         * @param expectedAgentPrompt
         *        The expected agent prompt for the agent turn in a test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedAgentPrompt(String expectedAgentPrompt);

        /**
         * <p>
         * The actual agent prompt for the agent turn in a test set execution.
         * </p>
         * 
         * @param actualAgentPrompt
         *        The actual agent prompt for the agent turn in a test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualAgentPrompt(String actualAgentPrompt);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * @param errorDetails
         *        The new value for the ErrorDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ExecutionErrorDetails errorDetails);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExecutionErrorDetails.Builder} avoiding
         * the need to create one manually via {@link ExecutionErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionErrorDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #errorDetails(ExecutionErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ExecutionErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ExecutionErrorDetails)
         */
        default Builder errorDetails(Consumer<ExecutionErrorDetails.Builder> errorDetails) {
            return errorDetails(ExecutionErrorDetails.builder().applyMutation(errorDetails).build());
        }

        /**
         * <p>
         * The actual elicited slot for the agent turn in a test set execution.
         * </p>
         * 
         * @param actualElicitedSlot
         *        The actual elicited slot for the agent turn in a test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualElicitedSlot(String actualElicitedSlot);

        /**
         * <p>
         * The actual intent for the agent turn in a test set execution.
         * </p>
         * 
         * @param actualIntent
         *        The actual intent for the agent turn in a test set execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualIntent(String actualIntent);
    }

    static final class BuilderImpl implements Builder {
        private String expectedAgentPrompt;

        private String actualAgentPrompt;

        private ExecutionErrorDetails errorDetails;

        private String actualElicitedSlot;

        private String actualIntent;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentTurnResult model) {
            expectedAgentPrompt(model.expectedAgentPrompt);
            actualAgentPrompt(model.actualAgentPrompt);
            errorDetails(model.errorDetails);
            actualElicitedSlot(model.actualElicitedSlot);
            actualIntent(model.actualIntent);
        }

        public final String getExpectedAgentPrompt() {
            return expectedAgentPrompt;
        }

        public final void setExpectedAgentPrompt(String expectedAgentPrompt) {
            this.expectedAgentPrompt = expectedAgentPrompt;
        }

        @Override
        public final Builder expectedAgentPrompt(String expectedAgentPrompt) {
            this.expectedAgentPrompt = expectedAgentPrompt;
            return this;
        }

        public final String getActualAgentPrompt() {
            return actualAgentPrompt;
        }

        public final void setActualAgentPrompt(String actualAgentPrompt) {
            this.actualAgentPrompt = actualAgentPrompt;
        }

        @Override
        public final Builder actualAgentPrompt(String actualAgentPrompt) {
            this.actualAgentPrompt = actualAgentPrompt;
            return this;
        }

        public final ExecutionErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ExecutionErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ExecutionErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getActualElicitedSlot() {
            return actualElicitedSlot;
        }

        public final void setActualElicitedSlot(String actualElicitedSlot) {
            this.actualElicitedSlot = actualElicitedSlot;
        }

        @Override
        public final Builder actualElicitedSlot(String actualElicitedSlot) {
            this.actualElicitedSlot = actualElicitedSlot;
            return this;
        }

        public final String getActualIntent() {
            return actualIntent;
        }

        public final void setActualIntent(String actualIntent) {
            this.actualIntent = actualIntent;
        }

        @Override
        public final Builder actualIntent(String actualIntent) {
            this.actualIntent = actualIntent;
            return this;
        }

        @Override
        public AgentTurnResult build() {
            return new AgentTurnResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
