/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionResultItemsResponse;

public class ListTestExecutionResultItemsPublisher
implements SdkPublisher<ListTestExecutionResultItemsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListTestExecutionResultItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestExecutionResultItemsPublisher(LexModelsV2AsyncClient client, ListTestExecutionResultItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestExecutionResultItemsPublisher(LexModelsV2AsyncClient client, ListTestExecutionResultItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestExecutionResultItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestExecutionResultItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTestExecutionResultItemsResponseFetcher
    implements AsyncPageFetcher<ListTestExecutionResultItemsResponse> {
        private ListTestExecutionResultItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestExecutionResultItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestExecutionResultItemsResponse> nextPage(ListTestExecutionResultItemsResponse previousPage) {
            if (previousPage == null) {
                return ListTestExecutionResultItemsPublisher.this.client.listTestExecutionResultItems(ListTestExecutionResultItemsPublisher.this.firstRequest);
            }
            return ListTestExecutionResultItemsPublisher.this.client.listTestExecutionResultItems((ListTestExecutionResultItemsRequest)((Object)ListTestExecutionResultItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

