/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentMetricsResponse;

public class ListIntentMetricsPublisher
implements SdkPublisher<ListIntentMetricsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListIntentMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIntentMetricsPublisher(LexModelsV2AsyncClient client, ListIntentMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIntentMetricsPublisher(LexModelsV2AsyncClient client, ListIntentMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIntentMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIntentMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListIntentMetricsResponseFetcher
    implements AsyncPageFetcher<ListIntentMetricsResponse> {
        private ListIntentMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListIntentMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIntentMetricsResponse> nextPage(ListIntentMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListIntentMetricsPublisher.this.client.listIntentMetrics(ListIntentMetricsPublisher.this.firstRequest);
            }
            return ListIntentMetricsPublisher.this.client.listIntentMetrics((ListIntentMetricsRequest)((Object)ListIntentMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

