/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TranscriptFormat {
    LEX("Lex"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TranscriptFormat> VALUE_MAP;
    private final String value;

    private TranscriptFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TranscriptFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TranscriptFormat> knownValues() {
        EnumSet<TranscriptFormat> knownValues = EnumSet.allOf(TranscriptFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TranscriptFormat.class, TranscriptFormat::toString);
    }
}

