/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.SpeechModelConfig;
import software.amazon.awssdk.services.lexmodelsv2.model.SpeechModelPreference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpeechRecognitionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpeechRecognitionSettings> {
    private static final SdkField<String> SPEECH_MODEL_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("speechModelPreference").getter(SpeechRecognitionSettings.getter(SpeechRecognitionSettings::speechModelPreferenceAsString)).setter(SpeechRecognitionSettings.setter(Builder::speechModelPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechModelPreference").build()}).build();
    private static final SdkField<SpeechModelConfig> SPEECH_MODEL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("speechModelConfig").getter(SpeechRecognitionSettings.getter(SpeechRecognitionSettings::speechModelConfig)).setter(SpeechRecognitionSettings.setter(Builder::speechModelConfig)).constructor(SpeechModelConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechModelConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEECH_MODEL_PREFERENCE_FIELD, SPEECH_MODEL_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpeechRecognitionSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String speechModelPreference;
    private final SpeechModelConfig speechModelConfig;

    private SpeechRecognitionSettings(BuilderImpl builder) {
        this.speechModelPreference = builder.speechModelPreference;
        this.speechModelConfig = builder.speechModelConfig;
    }

    public final SpeechModelPreference speechModelPreference() {
        return SpeechModelPreference.fromValue(this.speechModelPreference);
    }

    public final String speechModelPreferenceAsString() {
        return this.speechModelPreference;
    }

    public final SpeechModelConfig speechModelConfig() {
        return this.speechModelConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.speechModelPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.speechModelConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeechRecognitionSettings)) {
            return false;
        }
        SpeechRecognitionSettings other = (SpeechRecognitionSettings)obj;
        return Objects.equals(this.speechModelPreferenceAsString(), other.speechModelPreferenceAsString()) && Objects.equals(this.speechModelConfig(), other.speechModelConfig());
    }

    public final String toString() {
        return ToString.builder((String)"SpeechRecognitionSettings").add("SpeechModelPreference", (Object)this.speechModelPreferenceAsString()).add("SpeechModelConfig", (Object)this.speechModelConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "speechModelPreference": {
                return Optional.ofNullable(clazz.cast(this.speechModelPreferenceAsString()));
            }
            case "speechModelConfig": {
                return Optional.ofNullable(clazz.cast(this.speechModelConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("speechModelPreference", SPEECH_MODEL_PREFERENCE_FIELD);
        map.put("speechModelConfig", SPEECH_MODEL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpeechRecognitionSettings, T> g) {
        return obj -> g.apply((SpeechRecognitionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String speechModelPreference;
        private SpeechModelConfig speechModelConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeechRecognitionSettings model) {
            this.speechModelPreference(model.speechModelPreference);
            this.speechModelConfig(model.speechModelConfig);
        }

        public final String getSpeechModelPreference() {
            return this.speechModelPreference;
        }

        public final void setSpeechModelPreference(String speechModelPreference) {
            this.speechModelPreference = speechModelPreference;
        }

        @Override
        public final Builder speechModelPreference(String speechModelPreference) {
            this.speechModelPreference = speechModelPreference;
            return this;
        }

        @Override
        public final Builder speechModelPreference(SpeechModelPreference speechModelPreference) {
            this.speechModelPreference(speechModelPreference == null ? null : speechModelPreference.toString());
            return this;
        }

        public final SpeechModelConfig.Builder getSpeechModelConfig() {
            return this.speechModelConfig != null ? this.speechModelConfig.toBuilder() : null;
        }

        public final void setSpeechModelConfig(SpeechModelConfig.BuilderImpl speechModelConfig) {
            this.speechModelConfig = speechModelConfig != null ? speechModelConfig.build() : null;
        }

        @Override
        public final Builder speechModelConfig(SpeechModelConfig speechModelConfig) {
            this.speechModelConfig = speechModelConfig;
            return this;
        }

        public SpeechRecognitionSettings build() {
            return new SpeechRecognitionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpeechRecognitionSettings> {
        public Builder speechModelPreference(String var1);

        public Builder speechModelPreference(SpeechModelPreference var1);

        public Builder speechModelConfig(SpeechModelConfig var1);

        default public Builder speechModelConfig(Consumer<SpeechModelConfig.Builder> speechModelConfig) {
            return this.speechModelConfig((SpeechModelConfig)((SpeechModelConfig.Builder)SpeechModelConfig.builder().applyMutation(speechModelConfig)).build());
        }
    }
}

