/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBuiltInIntentsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListBuiltInIntentsResponse> {
    private static final SdkField<List<BuiltInIntentSummary>> BUILT_IN_INTENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("builtInIntentSummaries").getter(ListBuiltInIntentsResponse.getter(ListBuiltInIntentsResponse::builtInIntentSummaries)).setter(ListBuiltInIntentsResponse.setter(Builder::builtInIntentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("builtInIntentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuiltInIntentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBuiltInIntentsResponse.getter(ListBuiltInIntentsResponse::nextToken)).setter(ListBuiltInIntentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListBuiltInIntentsResponse.getter(ListBuiltInIntentsResponse::localeId)).setter(ListBuiltInIntentsResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILT_IN_INTENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, LOCALE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBuiltInIntentsResponse.memberNameToFieldInitializer();
    private final List<BuiltInIntentSummary> builtInIntentSummaries;
    private final String nextToken;
    private final String localeId;

    private ListBuiltInIntentsResponse(BuilderImpl builder) {
        super(builder);
        this.builtInIntentSummaries = builder.builtInIntentSummaries;
        this.nextToken = builder.nextToken;
        this.localeId = builder.localeId;
    }

    public final boolean hasBuiltInIntentSummaries() {
        return this.builtInIntentSummaries != null && !(this.builtInIntentSummaries instanceof SdkAutoConstructList);
    }

    public final List<BuiltInIntentSummary> builtInIntentSummaries() {
        return this.builtInIntentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String localeId() {
        return this.localeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuiltInIntentSummaries() ? this.builtInIntentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuiltInIntentsResponse)) {
            return false;
        }
        ListBuiltInIntentsResponse other = (ListBuiltInIntentsResponse)((Object)obj);
        return this.hasBuiltInIntentSummaries() == other.hasBuiltInIntentSummaries() && Objects.equals(this.builtInIntentSummaries(), other.builtInIntentSummaries()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.localeId(), other.localeId());
    }

    public final String toString() {
        return ToString.builder((String)"ListBuiltInIntentsResponse").add("BuiltInIntentSummaries", this.hasBuiltInIntentSummaries() ? this.builtInIntentSummaries() : null).add("NextToken", (Object)this.nextToken()).add("LocaleId", (Object)this.localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "builtInIntentSummaries": {
                return Optional.ofNullable(clazz.cast(this.builtInIntentSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("builtInIntentSummaries", BUILT_IN_INTENT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBuiltInIntentsResponse, T> g) {
        return obj -> g.apply((ListBuiltInIntentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private List<BuiltInIntentSummary> builtInIntentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuiltInIntentsResponse model) {
            super(model);
            this.builtInIntentSummaries(model.builtInIntentSummaries);
            this.nextToken(model.nextToken);
            this.localeId(model.localeId);
        }

        public final List<BuiltInIntentSummary.Builder> getBuiltInIntentSummaries() {
            List<BuiltInIntentSummary.Builder> result = BuiltInIntentSummaryListCopier.copyToBuilder(this.builtInIntentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuiltInIntentSummaries(Collection<BuiltInIntentSummary.BuilderImpl> builtInIntentSummaries) {
            this.builtInIntentSummaries = BuiltInIntentSummaryListCopier.copyFromBuilder(builtInIntentSummaries);
        }

        @Override
        public final Builder builtInIntentSummaries(Collection<BuiltInIntentSummary> builtInIntentSummaries) {
            this.builtInIntentSummaries = BuiltInIntentSummaryListCopier.copy(builtInIntentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builtInIntentSummaries(BuiltInIntentSummary ... builtInIntentSummaries) {
            this.builtInIntentSummaries(Arrays.asList(builtInIntentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builtInIntentSummaries(Consumer<BuiltInIntentSummary.Builder> ... builtInIntentSummaries) {
            this.builtInIntentSummaries(Stream.of(builtInIntentSummaries).map(c -> (BuiltInIntentSummary)((BuiltInIntentSummary.Builder)BuiltInIntentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public ListBuiltInIntentsResponse build() {
            return new ListBuiltInIntentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBuiltInIntentsResponse> {
        public Builder builtInIntentSummaries(Collection<BuiltInIntentSummary> var1);

        public Builder builtInIntentSummaries(BuiltInIntentSummary ... var1);

        public Builder builtInIntentSummaries(Consumer<BuiltInIntentSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder localeId(String var1);
    }
}

