/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse;

public class ListSessionAnalyticsDataIterable
implements SdkIterable<ListSessionAnalyticsDataResponse> {
    private final LexModelsV2Client client;
    private final ListSessionAnalyticsDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSessionAnalyticsDataIterable(LexModelsV2Client client, ListSessionAnalyticsDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSessionAnalyticsDataResponseFetcher();
    }

    public Iterator<ListSessionAnalyticsDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSessionAnalyticsDataResponseFetcher
    implements SyncPageFetcher<ListSessionAnalyticsDataResponse> {
        private ListSessionAnalyticsDataResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionAnalyticsDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSessionAnalyticsDataResponse nextPage(ListSessionAnalyticsDataResponse previousPage) {
            if (previousPage == null) {
                return ListSessionAnalyticsDataIterable.this.client.listSessionAnalyticsData(ListSessionAnalyticsDataIterable.this.firstRequest);
            }
            return ListSessionAnalyticsDataIterable.this.client.listSessionAnalyticsData((ListSessionAnalyticsDataRequest)((Object)ListSessionAnalyticsDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

