/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TestExecutionStatus {
    PENDING("Pending"),
    WAITING("Waiting"),
    IN_PROGRESS("InProgress"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TestExecutionStatus> VALUE_MAP;
    private final String value;

    private TestExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TestExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TestExecutionStatus> knownValues() {
        EnumSet<TestExecutionStatus> knownValues = EnumSet.allOf(TestExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TestExecutionStatus.class, TestExecutionStatus::toString);
    }
}

