/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.MergeStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImportRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, StartImportRequest> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(StartImportRequest.getter(StartImportRequest::importId)).setter(StartImportRequest.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<ImportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceSpecification").getter(StartImportRequest.getter(StartImportRequest::resourceSpecification)).setter(StartImportRequest.setter(Builder::resourceSpecification)).constructor(ImportResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergeStrategy").getter(StartImportRequest.getter(StartImportRequest::mergeStrategyAsString)).setter(StartImportRequest.setter(Builder::mergeStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()}).build();
    private static final SdkField<String> FILE_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePassword").getter(StartImportRequest.getter(StartImportRequest::filePassword)).setter(StartImportRequest.setter(Builder::filePassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, RESOURCE_SPECIFICATION_FIELD, MERGE_STRATEGY_FIELD, FILE_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartImportRequest.memberNameToFieldInitializer();
    private final String importId;
    private final ImportResourceSpecification resourceSpecification;
    private final String mergeStrategy;
    private final String filePassword;

    private StartImportRequest(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.resourceSpecification = builder.resourceSpecification;
        this.mergeStrategy = builder.mergeStrategy;
        this.filePassword = builder.filePassword;
    }

    public final String importId() {
        return this.importId;
    }

    public final ImportResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(this.mergeStrategy);
    }

    public final String mergeStrategyAsString() {
        return this.mergeStrategy;
    }

    public final String filePassword() {
        return this.filePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportRequest)) {
            return false;
        }
        StartImportRequest other = (StartImportRequest)((Object)obj);
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.mergeStrategyAsString(), other.mergeStrategyAsString()) && Objects.equals(this.filePassword(), other.filePassword());
    }

    public final String toString() {
        return ToString.builder((String)"StartImportRequest").add("ImportId", (Object)this.importId()).add("ResourceSpecification", (Object)this.resourceSpecification()).add("MergeStrategy", (Object)this.mergeStrategyAsString()).add("FilePassword", (Object)(this.filePassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "resourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "mergeStrategy": {
                return Optional.ofNullable(clazz.cast(this.mergeStrategyAsString()));
            }
            case "filePassword": {
                return Optional.ofNullable(clazz.cast(this.filePassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importId", IMPORT_ID_FIELD);
        map.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        map.put("mergeStrategy", MERGE_STRATEGY_FIELD);
        map.put("filePassword", FILE_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartImportRequest, T> g) {
        return obj -> g.apply((StartImportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String importId;
        private ImportResourceSpecification resourceSpecification;
        private String mergeStrategy;
        private String filePassword;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportRequest model) {
            super(model);
            this.importId(model.importId);
            this.resourceSpecification(model.resourceSpecification);
            this.mergeStrategy(model.mergeStrategy);
            this.filePassword(model.filePassword);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final ImportResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ImportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ImportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getMergeStrategy() {
            return this.mergeStrategy;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final String getFilePassword() {
            return this.filePassword;
        }

        public final void setFilePassword(String filePassword) {
            this.filePassword = filePassword;
        }

        @Override
        public final Builder filePassword(String filePassword) {
            this.filePassword = filePassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportRequest build() {
            return new StartImportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImportRequest> {
        public Builder importId(String var1);

        public Builder resourceSpecification(ImportResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ImportResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ImportResourceSpecification)((ImportResourceSpecification.Builder)ImportResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder mergeStrategy(String var1);

        public Builder mergeStrategy(MergeStrategy var1);

        public Builder filePassword(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

