/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotVersionReplicaSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.BotVersionReplicaSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotVersionReplicasResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListBotVersionReplicasResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListBotVersionReplicasResponse.getter(ListBotVersionReplicasResponse::botId)).setter(ListBotVersionReplicasResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceRegion").getter(ListBotVersionReplicasResponse.getter(ListBotVersionReplicasResponse::sourceRegion)).setter(ListBotVersionReplicasResponse.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()}).build();
    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicaRegion").getter(ListBotVersionReplicasResponse.getter(ListBotVersionReplicasResponse::replicaRegion)).setter(ListBotVersionReplicasResponse.setter(Builder::replicaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaRegion").build()}).build();
    private static final SdkField<List<BotVersionReplicaSummary>> BOT_VERSION_REPLICA_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botVersionReplicaSummaries").getter(ListBotVersionReplicasResponse.getter(ListBotVersionReplicasResponse::botVersionReplicaSummaries)).setter(ListBotVersionReplicasResponse.setter(Builder::botVersionReplicaSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersionReplicaSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotVersionReplicaSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBotVersionReplicasResponse.getter(ListBotVersionReplicasResponse::nextToken)).setter(ListBotVersionReplicasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, SOURCE_REGION_FIELD, REPLICA_REGION_FIELD, BOT_VERSION_REPLICA_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBotVersionReplicasResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String sourceRegion;
    private final String replicaRegion;
    private final List<BotVersionReplicaSummary> botVersionReplicaSummaries;
    private final String nextToken;

    private ListBotVersionReplicasResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.sourceRegion = builder.sourceRegion;
        this.replicaRegion = builder.replicaRegion;
        this.botVersionReplicaSummaries = builder.botVersionReplicaSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    public final String replicaRegion() {
        return this.replicaRegion;
    }

    public final boolean hasBotVersionReplicaSummaries() {
        return this.botVersionReplicaSummaries != null && !(this.botVersionReplicaSummaries instanceof SdkAutoConstructList);
    }

    public final List<BotVersionReplicaSummary> botVersionReplicaSummaries() {
        return this.botVersionReplicaSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotVersionReplicaSummaries() ? this.botVersionReplicaSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotVersionReplicasResponse)) {
            return false;
        }
        ListBotVersionReplicasResponse other = (ListBotVersionReplicasResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.replicaRegion(), other.replicaRegion()) && this.hasBotVersionReplicaSummaries() == other.hasBotVersionReplicaSummaries() && Objects.equals(this.botVersionReplicaSummaries(), other.botVersionReplicaSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotVersionReplicasResponse").add("BotId", (Object)this.botId()).add("SourceRegion", (Object)this.sourceRegion()).add("ReplicaRegion", (Object)this.replicaRegion()).add("BotVersionReplicaSummaries", this.hasBotVersionReplicaSummaries() ? this.botVersionReplicaSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "sourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "replicaRegion": {
                return Optional.ofNullable(clazz.cast(this.replicaRegion()));
            }
            case "botVersionReplicaSummaries": {
                return Optional.ofNullable(clazz.cast(this.botVersionReplicaSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("sourceRegion", SOURCE_REGION_FIELD);
        map.put("replicaRegion", REPLICA_REGION_FIELD);
        map.put("botVersionReplicaSummaries", BOT_VERSION_REPLICA_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotVersionReplicasResponse, T> g) {
        return obj -> g.apply((ListBotVersionReplicasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String sourceRegion;
        private String replicaRegion;
        private List<BotVersionReplicaSummary> botVersionReplicaSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotVersionReplicasResponse model) {
            super(model);
            this.botId(model.botId);
            this.sourceRegion(model.sourceRegion);
            this.replicaRegion(model.replicaRegion);
            this.botVersionReplicaSummaries(model.botVersionReplicaSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getReplicaRegion() {
            return this.replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final List<BotVersionReplicaSummary.Builder> getBotVersionReplicaSummaries() {
            List<BotVersionReplicaSummary.Builder> result = BotVersionReplicaSummaryListCopier.copyToBuilder(this.botVersionReplicaSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotVersionReplicaSummaries(Collection<BotVersionReplicaSummary.BuilderImpl> botVersionReplicaSummaries) {
            this.botVersionReplicaSummaries = BotVersionReplicaSummaryListCopier.copyFromBuilder(botVersionReplicaSummaries);
        }

        @Override
        public final Builder botVersionReplicaSummaries(Collection<BotVersionReplicaSummary> botVersionReplicaSummaries) {
            this.botVersionReplicaSummaries = BotVersionReplicaSummaryListCopier.copy(botVersionReplicaSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersionReplicaSummaries(BotVersionReplicaSummary ... botVersionReplicaSummaries) {
            this.botVersionReplicaSummaries(Arrays.asList(botVersionReplicaSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersionReplicaSummaries(Consumer<BotVersionReplicaSummary.Builder> ... botVersionReplicaSummaries) {
            this.botVersionReplicaSummaries(Stream.of(botVersionReplicaSummaries).map(c -> (BotVersionReplicaSummary)((BotVersionReplicaSummary.Builder)BotVersionReplicaSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBotVersionReplicasResponse build() {
            return new ListBotVersionReplicasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotVersionReplicasResponse> {
        public Builder botId(String var1);

        public Builder sourceRegion(String var1);

        public Builder replicaRegion(String var1);

        public Builder botVersionReplicaSummaries(Collection<BotVersionReplicaSummary> var1);

        public Builder botVersionReplicaSummaries(BotVersionReplicaSummary ... var1);

        public Builder botVersionReplicaSummaries(Consumer<BotVersionReplicaSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

