/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyErrors;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportResourceTarget;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetDiscrepancyReportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTestSetDiscrepancyReportResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DescribeTestSetDiscrepancyReportResponse> {
    private static final SdkField<String> TEST_SET_DISCREPANCY_REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetDiscrepancyReportId").getter(DescribeTestSetDiscrepancyReportResponse.getter(DescribeTestSetDiscrepancyReportResponse::testSetDiscrepancyReportId)).setter(DescribeTestSetDiscrepancyReportResponse.setter(Builder::testSetDiscrepancyReportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetDiscrepancyReportId").build()}).build();
    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetId").getter(DescribeTestSetDiscrepancyReportResponse.getter(DescribeTestSetDiscrepancyReportResponse::testSetId)).setter(DescribeTestSetDiscrepancyReportResponse.setter(Builder::testSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DescribeTestSetDiscrepancyReportResponse.getter(DescribeTestSetDiscrepancyReportResponse::creationDateTime)).setter(DescribeTestSetDiscrepancyReportResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<TestSetDiscrepancyReportResourceTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(DescribeTestSetDiscrepancyReportResponse.getter(DescribeTestSetDiscrepancyReportResponse::target)).setter(DescribeTestSetDiscrepancyReportResponse.setter(Builder::target)).constructor(TestSetDiscrepancyReportResourceTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> TEST_SET_DISCREPANCY_REPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetDiscrepancyReportStatus").getter(DescribeTestSetDiscrepancyReportResponse.getter(DescribeTestSetDiscrepancyReportResponse::testSetDiscrepancyReportStatusAsString)).setter(DescribeTestSetDiscrepancyReportResponse.setter(Builder::testSetDiscrepancyReportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetDiscrepancyReportStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATA_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDataTime").getter(DescribeTestSetDiscrepancyReportResponse.getter(DescribeTestSetDiscrepancyReportResponse::lastUpdatedDataTime)).setter(DescribeTestSetDiscrepancyReportResponse.setter(Builder::lastUpdatedDataTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDataTime").build()}).build();
    private static final SdkField<TestSetDiscrepancyErrors> TEST_SET_DISCREPANCY_TOP_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testSetDiscrepancyTopErrors").getter(DescribeTestSetDiscrepancyReportResponse.getter(DescribeTestSetDiscrepancyReportResponse::testSetDiscrepancyTopErrors)).setter(DescribeTestSetDiscrepancyReportResponse.setter(Builder::testSetDiscrepancyTopErrors)).constructor(TestSetDiscrepancyErrors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetDiscrepancyTopErrors").build()}).build();
    private static final SdkField<String> TEST_SET_DISCREPANCY_RAW_OUTPUT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetDiscrepancyRawOutputUrl").getter(DescribeTestSetDiscrepancyReportResponse.getter(DescribeTestSetDiscrepancyReportResponse::testSetDiscrepancyRawOutputUrl)).setter(DescribeTestSetDiscrepancyReportResponse.setter(Builder::testSetDiscrepancyRawOutputUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetDiscrepancyRawOutputUrl").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(DescribeTestSetDiscrepancyReportResponse.getter(DescribeTestSetDiscrepancyReportResponse::failureReasons)).setter(DescribeTestSetDiscrepancyReportResponse.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_DISCREPANCY_REPORT_ID_FIELD, TEST_SET_ID_FIELD, CREATION_DATE_TIME_FIELD, TARGET_FIELD, TEST_SET_DISCREPANCY_REPORT_STATUS_FIELD, LAST_UPDATED_DATA_TIME_FIELD, TEST_SET_DISCREPANCY_TOP_ERRORS_FIELD, TEST_SET_DISCREPANCY_RAW_OUTPUT_URL_FIELD, FAILURE_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTestSetDiscrepancyReportResponse.memberNameToFieldInitializer();
    private final String testSetDiscrepancyReportId;
    private final String testSetId;
    private final Instant creationDateTime;
    private final TestSetDiscrepancyReportResourceTarget target;
    private final String testSetDiscrepancyReportStatus;
    private final Instant lastUpdatedDataTime;
    private final TestSetDiscrepancyErrors testSetDiscrepancyTopErrors;
    private final String testSetDiscrepancyRawOutputUrl;
    private final List<String> failureReasons;

    private DescribeTestSetDiscrepancyReportResponse(BuilderImpl builder) {
        super(builder);
        this.testSetDiscrepancyReportId = builder.testSetDiscrepancyReportId;
        this.testSetId = builder.testSetId;
        this.creationDateTime = builder.creationDateTime;
        this.target = builder.target;
        this.testSetDiscrepancyReportStatus = builder.testSetDiscrepancyReportStatus;
        this.lastUpdatedDataTime = builder.lastUpdatedDataTime;
        this.testSetDiscrepancyTopErrors = builder.testSetDiscrepancyTopErrors;
        this.testSetDiscrepancyRawOutputUrl = builder.testSetDiscrepancyRawOutputUrl;
        this.failureReasons = builder.failureReasons;
    }

    public final String testSetDiscrepancyReportId() {
        return this.testSetDiscrepancyReportId;
    }

    public final String testSetId() {
        return this.testSetId;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final TestSetDiscrepancyReportResourceTarget target() {
        return this.target;
    }

    public final TestSetDiscrepancyReportStatus testSetDiscrepancyReportStatus() {
        return TestSetDiscrepancyReportStatus.fromValue(this.testSetDiscrepancyReportStatus);
    }

    public final String testSetDiscrepancyReportStatusAsString() {
        return this.testSetDiscrepancyReportStatus;
    }

    public final Instant lastUpdatedDataTime() {
        return this.lastUpdatedDataTime;
    }

    public final TestSetDiscrepancyErrors testSetDiscrepancyTopErrors() {
        return this.testSetDiscrepancyTopErrors;
    }

    public final String testSetDiscrepancyRawOutputUrl() {
        return this.testSetDiscrepancyRawOutputUrl;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetDiscrepancyReportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetDiscrepancyReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDataTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetDiscrepancyTopErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetDiscrepancyRawOutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTestSetDiscrepancyReportResponse)) {
            return false;
        }
        DescribeTestSetDiscrepancyReportResponse other = (DescribeTestSetDiscrepancyReportResponse)((Object)obj);
        return Objects.equals(this.testSetDiscrepancyReportId(), other.testSetDiscrepancyReportId()) && Objects.equals(this.testSetId(), other.testSetId()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.testSetDiscrepancyReportStatusAsString(), other.testSetDiscrepancyReportStatusAsString()) && Objects.equals(this.lastUpdatedDataTime(), other.lastUpdatedDataTime()) && Objects.equals(this.testSetDiscrepancyTopErrors(), other.testSetDiscrepancyTopErrors()) && Objects.equals(this.testSetDiscrepancyRawOutputUrl(), other.testSetDiscrepancyRawOutputUrl()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTestSetDiscrepancyReportResponse").add("TestSetDiscrepancyReportId", (Object)this.testSetDiscrepancyReportId()).add("TestSetId", (Object)this.testSetId()).add("CreationDateTime", (Object)this.creationDateTime()).add("Target", (Object)this.target()).add("TestSetDiscrepancyReportStatus", (Object)this.testSetDiscrepancyReportStatusAsString()).add("LastUpdatedDataTime", (Object)this.lastUpdatedDataTime()).add("TestSetDiscrepancyTopErrors", (Object)this.testSetDiscrepancyTopErrors()).add("TestSetDiscrepancyRawOutputUrl", (Object)this.testSetDiscrepancyRawOutputUrl()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSetDiscrepancyReportId": {
                return Optional.ofNullable(clazz.cast(this.testSetDiscrepancyReportId()));
            }
            case "testSetId": {
                return Optional.ofNullable(clazz.cast(this.testSetId()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "testSetDiscrepancyReportStatus": {
                return Optional.ofNullable(clazz.cast(this.testSetDiscrepancyReportStatusAsString()));
            }
            case "lastUpdatedDataTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDataTime()));
            }
            case "testSetDiscrepancyTopErrors": {
                return Optional.ofNullable(clazz.cast(this.testSetDiscrepancyTopErrors()));
            }
            case "testSetDiscrepancyRawOutputUrl": {
                return Optional.ofNullable(clazz.cast(this.testSetDiscrepancyRawOutputUrl()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testSetDiscrepancyReportId", TEST_SET_DISCREPANCY_REPORT_ID_FIELD);
        map.put("testSetId", TEST_SET_ID_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("testSetDiscrepancyReportStatus", TEST_SET_DISCREPANCY_REPORT_STATUS_FIELD);
        map.put("lastUpdatedDataTime", LAST_UPDATED_DATA_TIME_FIELD);
        map.put("testSetDiscrepancyTopErrors", TEST_SET_DISCREPANCY_TOP_ERRORS_FIELD);
        map.put("testSetDiscrepancyRawOutputUrl", TEST_SET_DISCREPANCY_RAW_OUTPUT_URL_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTestSetDiscrepancyReportResponse, T> g) {
        return obj -> g.apply((DescribeTestSetDiscrepancyReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String testSetDiscrepancyReportId;
        private String testSetId;
        private Instant creationDateTime;
        private TestSetDiscrepancyReportResourceTarget target;
        private String testSetDiscrepancyReportStatus;
        private Instant lastUpdatedDataTime;
        private TestSetDiscrepancyErrors testSetDiscrepancyTopErrors;
        private String testSetDiscrepancyRawOutputUrl;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTestSetDiscrepancyReportResponse model) {
            super(model);
            this.testSetDiscrepancyReportId(model.testSetDiscrepancyReportId);
            this.testSetId(model.testSetId);
            this.creationDateTime(model.creationDateTime);
            this.target(model.target);
            this.testSetDiscrepancyReportStatus(model.testSetDiscrepancyReportStatus);
            this.lastUpdatedDataTime(model.lastUpdatedDataTime);
            this.testSetDiscrepancyTopErrors(model.testSetDiscrepancyTopErrors);
            this.testSetDiscrepancyRawOutputUrl(model.testSetDiscrepancyRawOutputUrl);
            this.failureReasons(model.failureReasons);
        }

        public final String getTestSetDiscrepancyReportId() {
            return this.testSetDiscrepancyReportId;
        }

        public final void setTestSetDiscrepancyReportId(String testSetDiscrepancyReportId) {
            this.testSetDiscrepancyReportId = testSetDiscrepancyReportId;
        }

        @Override
        public final Builder testSetDiscrepancyReportId(String testSetDiscrepancyReportId) {
            this.testSetDiscrepancyReportId = testSetDiscrepancyReportId;
            return this;
        }

        public final String getTestSetId() {
            return this.testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final TestSetDiscrepancyReportResourceTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(TestSetDiscrepancyReportResourceTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TestSetDiscrepancyReportResourceTarget target) {
            this.target = target;
            return this;
        }

        public final String getTestSetDiscrepancyReportStatus() {
            return this.testSetDiscrepancyReportStatus;
        }

        public final void setTestSetDiscrepancyReportStatus(String testSetDiscrepancyReportStatus) {
            this.testSetDiscrepancyReportStatus = testSetDiscrepancyReportStatus;
        }

        @Override
        public final Builder testSetDiscrepancyReportStatus(String testSetDiscrepancyReportStatus) {
            this.testSetDiscrepancyReportStatus = testSetDiscrepancyReportStatus;
            return this;
        }

        @Override
        public final Builder testSetDiscrepancyReportStatus(TestSetDiscrepancyReportStatus testSetDiscrepancyReportStatus) {
            this.testSetDiscrepancyReportStatus(testSetDiscrepancyReportStatus == null ? null : testSetDiscrepancyReportStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedDataTime() {
            return this.lastUpdatedDataTime;
        }

        public final void setLastUpdatedDataTime(Instant lastUpdatedDataTime) {
            this.lastUpdatedDataTime = lastUpdatedDataTime;
        }

        @Override
        public final Builder lastUpdatedDataTime(Instant lastUpdatedDataTime) {
            this.lastUpdatedDataTime = lastUpdatedDataTime;
            return this;
        }

        public final TestSetDiscrepancyErrors.Builder getTestSetDiscrepancyTopErrors() {
            return this.testSetDiscrepancyTopErrors != null ? this.testSetDiscrepancyTopErrors.toBuilder() : null;
        }

        public final void setTestSetDiscrepancyTopErrors(TestSetDiscrepancyErrors.BuilderImpl testSetDiscrepancyTopErrors) {
            this.testSetDiscrepancyTopErrors = testSetDiscrepancyTopErrors != null ? testSetDiscrepancyTopErrors.build() : null;
        }

        @Override
        public final Builder testSetDiscrepancyTopErrors(TestSetDiscrepancyErrors testSetDiscrepancyTopErrors) {
            this.testSetDiscrepancyTopErrors = testSetDiscrepancyTopErrors;
            return this;
        }

        public final String getTestSetDiscrepancyRawOutputUrl() {
            return this.testSetDiscrepancyRawOutputUrl;
        }

        public final void setTestSetDiscrepancyRawOutputUrl(String testSetDiscrepancyRawOutputUrl) {
            this.testSetDiscrepancyRawOutputUrl = testSetDiscrepancyRawOutputUrl;
        }

        @Override
        public final Builder testSetDiscrepancyRawOutputUrl(String testSetDiscrepancyRawOutputUrl) {
            this.testSetDiscrepancyRawOutputUrl = testSetDiscrepancyRawOutputUrl;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        @Override
        public DescribeTestSetDiscrepancyReportResponse build() {
            return new DescribeTestSetDiscrepancyReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTestSetDiscrepancyReportResponse> {
        public Builder testSetDiscrepancyReportId(String var1);

        public Builder testSetId(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder target(TestSetDiscrepancyReportResourceTarget var1);

        default public Builder target(Consumer<TestSetDiscrepancyReportResourceTarget.Builder> target) {
            return this.target((TestSetDiscrepancyReportResourceTarget)((TestSetDiscrepancyReportResourceTarget.Builder)TestSetDiscrepancyReportResourceTarget.builder().applyMutation(target)).build());
        }

        public Builder testSetDiscrepancyReportStatus(String var1);

        public Builder testSetDiscrepancyReportStatus(TestSetDiscrepancyReportStatus var1);

        public Builder lastUpdatedDataTime(Instant var1);

        public Builder testSetDiscrepancyTopErrors(TestSetDiscrepancyErrors var1);

        default public Builder testSetDiscrepancyTopErrors(Consumer<TestSetDiscrepancyErrors.Builder> testSetDiscrepancyTopErrors) {
            return this.testSetDiscrepancyTopErrors((TestSetDiscrepancyErrors)((TestSetDiscrepancyErrors.Builder)TestSetDiscrepancyErrors.builder().applyMutation(testSetDiscrepancyTopErrors)).build());
        }

        public Builder testSetDiscrepancyRawOutputUrl(String var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);
    }
}

