/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetRecordsResponse;

public class ListTestSetRecordsIterable
implements SdkIterable<ListTestSetRecordsResponse> {
    private final LexModelsV2Client client;
    private final ListTestSetRecordsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestSetRecordsIterable(LexModelsV2Client client, ListTestSetRecordsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestSetRecordsResponseFetcher();
    }

    public Iterator<ListTestSetRecordsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestSetRecordsResponseFetcher
    implements SyncPageFetcher<ListTestSetRecordsResponse> {
        private ListTestSetRecordsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestSetRecordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestSetRecordsResponse nextPage(ListTestSetRecordsResponse previousPage) {
            if (previousPage == null) {
                return ListTestSetRecordsIterable.this.client.listTestSetRecords(ListTestSetRecordsIterable.this.firstRequest);
            }
            return ListTestSetRecordsIterable.this.client.listTestSetRecords((ListTestSetRecordsRequest)((Object)ListTestSetRecordsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

