/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatusCountMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntentClassificationTestResultItemCounts
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntentClassificationTestResultItemCounts> {
    private static final SdkField<Integer> TOTAL_RESULT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalResultCount").getter(IntentClassificationTestResultItemCounts.getter(IntentClassificationTestResultItemCounts::totalResultCount)).setter(IntentClassificationTestResultItemCounts.setter(Builder::totalResultCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResultCount").build()}).build();
    private static final SdkField<Map<String, Integer>> SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("speechTranscriptionResultCounts").getter(IntentClassificationTestResultItemCounts.getter(IntentClassificationTestResultItemCounts::speechTranscriptionResultCountsAsStrings)).setter(IntentClassificationTestResultItemCounts.setter(Builder::speechTranscriptionResultCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResultCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> INTENT_MATCH_RESULT_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("intentMatchResultCounts").getter(IntentClassificationTestResultItemCounts.getter(IntentClassificationTestResultItemCounts::intentMatchResultCountsAsStrings)).setter(IntentClassificationTestResultItemCounts.setter(Builder::intentMatchResultCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentMatchResultCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_RESULT_COUNT_FIELD, SPEECH_TRANSCRIPTION_RESULT_COUNTS_FIELD, INTENT_MATCH_RESULT_COUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer totalResultCount;
    private final Map<String, Integer> speechTranscriptionResultCounts;
    private final Map<String, Integer> intentMatchResultCounts;

    private IntentClassificationTestResultItemCounts(BuilderImpl builder) {
        this.totalResultCount = builder.totalResultCount;
        this.speechTranscriptionResultCounts = builder.speechTranscriptionResultCounts;
        this.intentMatchResultCounts = builder.intentMatchResultCounts;
    }

    public final Integer totalResultCount() {
        return this.totalResultCount;
    }

    public final Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(this.speechTranscriptionResultCounts);
    }

    public final boolean hasSpeechTranscriptionResultCounts() {
        return this.speechTranscriptionResultCounts != null && !(this.speechTranscriptionResultCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> speechTranscriptionResultCountsAsStrings() {
        return this.speechTranscriptionResultCounts;
    }

    public final Map<TestResultMatchStatus, Integer> intentMatchResultCounts() {
        return TestResultMatchStatusCountMapCopier.copyStringToEnum(this.intentMatchResultCounts);
    }

    public final boolean hasIntentMatchResultCounts() {
        return this.intentMatchResultCounts != null && !(this.intentMatchResultCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> intentMatchResultCountsAsStrings() {
        return this.intentMatchResultCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResultCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpeechTranscriptionResultCounts() ? this.speechTranscriptionResultCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntentMatchResultCounts() ? this.intentMatchResultCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentClassificationTestResultItemCounts)) {
            return false;
        }
        IntentClassificationTestResultItemCounts other = (IntentClassificationTestResultItemCounts)obj;
        return Objects.equals(this.totalResultCount(), other.totalResultCount()) && this.hasSpeechTranscriptionResultCounts() == other.hasSpeechTranscriptionResultCounts() && Objects.equals(this.speechTranscriptionResultCountsAsStrings(), other.speechTranscriptionResultCountsAsStrings()) && this.hasIntentMatchResultCounts() == other.hasIntentMatchResultCounts() && Objects.equals(this.intentMatchResultCountsAsStrings(), other.intentMatchResultCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"IntentClassificationTestResultItemCounts").add("TotalResultCount", (Object)this.totalResultCount()).add("SpeechTranscriptionResultCounts", this.hasSpeechTranscriptionResultCounts() ? this.speechTranscriptionResultCountsAsStrings() : null).add("IntentMatchResultCounts", this.hasIntentMatchResultCounts() ? this.intentMatchResultCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalResultCount": {
                return Optional.ofNullable(clazz.cast(this.totalResultCount()));
            }
            case "speechTranscriptionResultCounts": {
                return Optional.ofNullable(clazz.cast(this.speechTranscriptionResultCountsAsStrings()));
            }
            case "intentMatchResultCounts": {
                return Optional.ofNullable(clazz.cast(this.intentMatchResultCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentClassificationTestResultItemCounts, T> g) {
        return obj -> g.apply((IntentClassificationTestResultItemCounts)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalResultCount;
        private Map<String, Integer> speechTranscriptionResultCounts = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Integer> intentMatchResultCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IntentClassificationTestResultItemCounts model) {
            this.totalResultCount(model.totalResultCount);
            this.speechTranscriptionResultCountsWithStrings(model.speechTranscriptionResultCounts);
            this.intentMatchResultCountsWithStrings(model.intentMatchResultCounts);
        }

        public final Integer getTotalResultCount() {
            return this.totalResultCount;
        }

        public final void setTotalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
        }

        @Override
        public final Builder totalResultCount(Integer totalResultCount) {
            this.totalResultCount = totalResultCount;
            return this;
        }

        public final Map<String, Integer> getSpeechTranscriptionResultCounts() {
            if (this.speechTranscriptionResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.speechTranscriptionResultCounts;
        }

        public final void setSpeechTranscriptionResultCounts(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
        }

        @Override
        public final Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copy(speechTranscriptionResultCounts);
            return this;
        }

        @Override
        public final Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> speechTranscriptionResultCounts) {
            this.speechTranscriptionResultCounts = TestResultMatchStatusCountMapCopier.copyEnumToString(speechTranscriptionResultCounts);
            return this;
        }

        public final Map<String, Integer> getIntentMatchResultCounts() {
            if (this.intentMatchResultCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.intentMatchResultCounts;
        }

        public final void setIntentMatchResultCounts(Map<String, Integer> intentMatchResultCounts) {
            this.intentMatchResultCounts = TestResultMatchStatusCountMapCopier.copy(intentMatchResultCounts);
        }

        @Override
        public final Builder intentMatchResultCountsWithStrings(Map<String, Integer> intentMatchResultCounts) {
            this.intentMatchResultCounts = TestResultMatchStatusCountMapCopier.copy(intentMatchResultCounts);
            return this;
        }

        @Override
        public final Builder intentMatchResultCounts(Map<TestResultMatchStatus, Integer> intentMatchResultCounts) {
            this.intentMatchResultCounts = TestResultMatchStatusCountMapCopier.copyEnumToString(intentMatchResultCounts);
            return this;
        }

        public IntentClassificationTestResultItemCounts build() {
            return new IntentClassificationTestResultItemCounts(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntentClassificationTestResultItemCounts> {
        public Builder totalResultCount(Integer var1);

        public Builder speechTranscriptionResultCountsWithStrings(Map<String, Integer> var1);

        public Builder speechTranscriptionResultCounts(Map<TestResultMatchStatus, Integer> var1);

        public Builder intentMatchResultCountsWithStrings(Map<String, Integer> var1);

        public Builder intentMatchResultCounts(Map<TestResultMatchStatus, Integer> var1);
    }
}

