/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsResponse;

public class ListUtteranceMetricsPublisher
implements SdkPublisher<ListUtteranceMetricsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListUtteranceMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUtteranceMetricsPublisher(LexModelsV2AsyncClient client, ListUtteranceMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUtteranceMetricsPublisher(LexModelsV2AsyncClient client, ListUtteranceMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUtteranceMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUtteranceMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListUtteranceMetricsResponseFetcher
    implements AsyncPageFetcher<ListUtteranceMetricsResponse> {
        private ListUtteranceMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListUtteranceMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUtteranceMetricsResponse> nextPage(ListUtteranceMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListUtteranceMetricsPublisher.this.client.listUtteranceMetrics(ListUtteranceMetricsPublisher.this.firstRequest);
            }
            return ListUtteranceMetricsPublisher.this.client.listUtteranceMetrics((ListUtteranceMetricsRequest)((Object)ListUtteranceMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

