/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;

public class ListBuiltInIntentsIterable
implements SdkIterable<ListBuiltInIntentsResponse> {
    private final LexModelsV2Client client;
    private final ListBuiltInIntentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBuiltInIntentsIterable(LexModelsV2Client client, ListBuiltInIntentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBuiltInIntentsResponseFetcher();
    }

    public Iterator<ListBuiltInIntentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBuiltInIntentsResponseFetcher
    implements SyncPageFetcher<ListBuiltInIntentsResponse> {
        private ListBuiltInIntentsResponseFetcher() {
        }

        public boolean hasNextPage(ListBuiltInIntentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBuiltInIntentsResponse nextPage(ListBuiltInIntentsResponse previousPage) {
            if (previousPage == null) {
                return ListBuiltInIntentsIterable.this.client.listBuiltInIntents(ListBuiltInIntentsIterable.this.firstRequest);
            }
            return ListBuiltInIntentsIterable.this.client.listBuiltInIntents((ListBuiltInIntentsRequest)((Object)ListBuiltInIntentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

