/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.ExportResourceSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.ImportExportFileFormat;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExportRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, CreateExportRequest> {
    private static final SdkField<ExportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceSpecification").getter(CreateExportRequest.getter(CreateExportRequest::resourceSpecification)).setter(CreateExportRequest.setter(Builder::resourceSpecification)).constructor(ExportResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(CreateExportRequest.getter(CreateExportRequest::fileFormatAsString)).setter(CreateExportRequest.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<String> FILE_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePassword").getter(CreateExportRequest.getter(CreateExportRequest::filePassword)).setter(CreateExportRequest.setter(Builder::filePassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SPECIFICATION_FIELD, FILE_FORMAT_FIELD, FILE_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExportRequest.memberNameToFieldInitializer();
    private final ExportResourceSpecification resourceSpecification;
    private final String fileFormat;
    private final String filePassword;

    private CreateExportRequest(BuilderImpl builder) {
        super(builder);
        this.resourceSpecification = builder.resourceSpecification;
        this.fileFormat = builder.fileFormat;
        this.filePassword = builder.filePassword;
    }

    public final ExportResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public final ImportExportFileFormat fileFormat() {
        return ImportExportFileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final String filePassword() {
        return this.filePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportRequest)) {
            return false;
        }
        CreateExportRequest other = (CreateExportRequest)((Object)obj);
        return Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.filePassword(), other.filePassword());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExportRequest").add("ResourceSpecification", (Object)this.resourceSpecification()).add("FileFormat", (Object)this.fileFormatAsString()).add("FilePassword", (Object)(this.filePassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "filePassword": {
                return Optional.ofNullable(clazz.cast(this.filePassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        map.put("fileFormat", FILE_FORMAT_FIELD);
        map.put("filePassword", FILE_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExportRequest, T> g) {
        return obj -> g.apply((CreateExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private ExportResourceSpecification resourceSpecification;
        private String fileFormat;
        private String filePassword;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportRequest model) {
            super(model);
            this.resourceSpecification(model.resourceSpecification);
            this.fileFormat(model.fileFormat);
            this.filePassword(model.filePassword);
        }

        public final ExportResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ExportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ExportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(ImportExportFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getFilePassword() {
            return this.filePassword;
        }

        public final void setFilePassword(String filePassword) {
            this.filePassword = filePassword;
        }

        @Override
        public final Builder filePassword(String filePassword) {
            this.filePassword = filePassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportRequest build() {
            return new CreateExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExportRequest> {
        public Builder resourceSpecification(ExportResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ExportResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ExportResourceSpecification)((ExportResourceSpecification.Builder)ExportResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder fileFormat(String var1);

        public Builder fileFormat(ImportExportFileFormat var1);

        public Builder filePassword(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

