/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConversationLevelSlotResolutionResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConversationLevelSlotResolutionResultItem> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(ConversationLevelSlotResolutionResultItem.getter(ConversationLevelSlotResolutionResultItem::intentName)).setter(ConversationLevelSlotResolutionResultItem.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotName").getter(ConversationLevelSlotResolutionResultItem.getter(ConversationLevelSlotResolutionResultItem::slotName)).setter(ConversationLevelSlotResolutionResultItem.setter(Builder::slotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotName").build()}).build();
    private static final SdkField<String> MATCH_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchResult").getter(ConversationLevelSlotResolutionResultItem.getter(ConversationLevelSlotResolutionResultItem::matchResultAsString)).setter(ConversationLevelSlotResolutionResultItem.setter(Builder::matchResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD, SLOT_NAME_FIELD, MATCH_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConversationLevelSlotResolutionResultItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String intentName;
    private final String slotName;
    private final String matchResult;

    private ConversationLevelSlotResolutionResultItem(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.slotName = builder.slotName;
        this.matchResult = builder.matchResult;
    }

    public final String intentName() {
        return this.intentName;
    }

    public final String slotName() {
        return this.slotName;
    }

    public final TestResultMatchStatus matchResult() {
        return TestResultMatchStatus.fromValue(this.matchResult);
    }

    public final String matchResultAsString() {
        return this.matchResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchResultAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLevelSlotResolutionResultItem)) {
            return false;
        }
        ConversationLevelSlotResolutionResultItem other = (ConversationLevelSlotResolutionResultItem)obj;
        return Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.slotName(), other.slotName()) && Objects.equals(this.matchResultAsString(), other.matchResultAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConversationLevelSlotResolutionResultItem").add("IntentName", (Object)this.intentName()).add("SlotName", (Object)this.slotName()).add("MatchResult", (Object)this.matchResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "slotName": {
                return Optional.ofNullable(clazz.cast(this.slotName()));
            }
            case "matchResult": {
                return Optional.ofNullable(clazz.cast(this.matchResultAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("intentName", INTENT_NAME_FIELD);
        map.put("slotName", SLOT_NAME_FIELD);
        map.put("matchResult", MATCH_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConversationLevelSlotResolutionResultItem, T> g) {
        return obj -> g.apply((ConversationLevelSlotResolutionResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String intentName;
        private String slotName;
        private String matchResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLevelSlotResolutionResultItem model) {
            this.intentName(model.intentName);
            this.slotName(model.slotName);
            this.matchResult(model.matchResult);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getSlotName() {
            return this.slotName;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public final String getMatchResult() {
            return this.matchResult;
        }

        public final void setMatchResult(String matchResult) {
            this.matchResult = matchResult;
        }

        @Override
        public final Builder matchResult(String matchResult) {
            this.matchResult = matchResult;
            return this;
        }

        @Override
        public final Builder matchResult(TestResultMatchStatus matchResult) {
            this.matchResult(matchResult == null ? null : matchResult.toString());
            return this;
        }

        public ConversationLevelSlotResolutionResultItem build() {
            return new ConversationLevelSlotResolutionResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConversationLevelSlotResolutionResultItem> {
        public Builder intentName(String var1);

        public Builder slotName(String var1);

        public Builder matchResult(String var1);

        public Builder matchResult(TestResultMatchStatus var1);
    }
}

