/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BotStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.BotType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BotSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BotSummary> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(BotSummary.getter(BotSummary::botId)).setter(BotSummary.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botName").getter(BotSummary.getter(BotSummary::botName)).setter(BotSummary.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(BotSummary.getter(BotSummary::description)).setter(BotSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botStatus").getter(BotSummary.getter(BotSummary::botStatusAsString)).setter(BotSummary.setter(Builder::botStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()}).build();
    private static final SdkField<String> LATEST_BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestBotVersion").getter(BotSummary.getter(BotSummary::latestBotVersion)).setter(BotSummary.setter(Builder::latestBotVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestBotVersion").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(BotSummary.getter(BotSummary::lastUpdatedDateTime)).setter(BotSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> BOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botType").getter(BotSummary.getter(BotSummary::botTypeAsString)).setter(BotSummary.setter(Builder::botType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD, DESCRIPTION_FIELD, BOT_STATUS_FIELD, LATEST_BOT_VERSION_FIELD, LAST_UPDATED_DATE_TIME_FIELD, BOT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BotSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String botId;
    private final String botName;
    private final String description;
    private final String botStatus;
    private final String latestBotVersion;
    private final Instant lastUpdatedDateTime;
    private final String botType;

    private BotSummary(BuilderImpl builder) {
        this.botId = builder.botId;
        this.botName = builder.botName;
        this.description = builder.description;
        this.botStatus = builder.botStatus;
        this.latestBotVersion = builder.latestBotVersion;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.botType = builder.botType;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botName() {
        return this.botName;
    }

    public final String description() {
        return this.description;
    }

    public final BotStatus botStatus() {
        return BotStatus.fromValue(this.botStatus);
    }

    public final String botStatusAsString() {
        return this.botStatus;
    }

    public final String latestBotVersion() {
        return this.latestBotVersion;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final BotType botType() {
        return BotType.fromValue(this.botType);
    }

    public final String botTypeAsString() {
        return this.botType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestBotVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.botTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotSummary)) {
            return false;
        }
        BotSummary other = (BotSummary)obj;
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botName(), other.botName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.botStatusAsString(), other.botStatusAsString()) && Objects.equals(this.latestBotVersion(), other.latestBotVersion()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.botTypeAsString(), other.botTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BotSummary").add("BotId", (Object)this.botId()).add("BotName", (Object)this.botName()).add("Description", (Object)this.description()).add("BotStatus", (Object)this.botStatusAsString()).add("LatestBotVersion", (Object)this.latestBotVersion()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("BotType", (Object)this.botTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "botStatus": {
                return Optional.ofNullable(clazz.cast(this.botStatusAsString()));
            }
            case "latestBotVersion": {
                return Optional.ofNullable(clazz.cast(this.latestBotVersion()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "botType": {
                return Optional.ofNullable(clazz.cast(this.botTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botName", BOT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("botStatus", BOT_STATUS_FIELD);
        map.put("latestBotVersion", LATEST_BOT_VERSION_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("botType", BOT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BotSummary, T> g) {
        return obj -> g.apply((BotSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botId;
        private String botName;
        private String description;
        private String botStatus;
        private String latestBotVersion;
        private Instant lastUpdatedDateTime;
        private String botType;

        private BuilderImpl() {
        }

        private BuilderImpl(BotSummary model) {
            this.botId(model.botId);
            this.botName(model.botName);
            this.description(model.description);
            this.botStatus(model.botStatus);
            this.latestBotVersion(model.latestBotVersion);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.botType(model.botType);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotName() {
            return this.botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotStatus() {
            return this.botStatus;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final String getLatestBotVersion() {
            return this.latestBotVersion;
        }

        public final void setLatestBotVersion(String latestBotVersion) {
            this.latestBotVersion = latestBotVersion;
        }

        @Override
        public final Builder latestBotVersion(String latestBotVersion) {
            this.latestBotVersion = latestBotVersion;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getBotType() {
            return this.botType;
        }

        public final void setBotType(String botType) {
            this.botType = botType;
        }

        @Override
        public final Builder botType(String botType) {
            this.botType = botType;
            return this;
        }

        @Override
        public final Builder botType(BotType botType) {
            this.botType(botType == null ? null : botType.toString());
            return this;
        }

        public BotSummary build() {
            return new BotSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BotSummary> {
        public Builder botId(String var1);

        public Builder botName(String var1);

        public Builder description(String var1);

        public Builder botStatus(String var1);

        public Builder botStatus(BotStatus var1);

        public Builder latestBotVersion(String var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder botType(String var1);

        public Builder botType(BotType var1);
    }
}

