/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotVersionReplicationStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BotVersionReplicaSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BotVersionReplicaSummary> {
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(BotVersionReplicaSummary.getter(BotVersionReplicaSummary::botVersion)).setter(BotVersionReplicaSummary.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> BOT_VERSION_REPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersionReplicationStatus").getter(BotVersionReplicaSummary.getter(BotVersionReplicaSummary::botVersionReplicationStatusAsString)).setter(BotVersionReplicaSummary.setter(Builder::botVersionReplicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersionReplicationStatus").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(BotVersionReplicaSummary.getter(BotVersionReplicaSummary::creationDateTime)).setter(BotVersionReplicaSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(BotVersionReplicaSummary.getter(BotVersionReplicaSummary::failureReasons)).setter(BotVersionReplicaSummary.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_VERSION_FIELD, BOT_VERSION_REPLICATION_STATUS_FIELD, CREATION_DATE_TIME_FIELD, FAILURE_REASONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String botVersion;
    private final String botVersionReplicationStatus;
    private final Instant creationDateTime;
    private final List<String> failureReasons;

    private BotVersionReplicaSummary(BuilderImpl builder) {
        this.botVersion = builder.botVersion;
        this.botVersionReplicationStatus = builder.botVersionReplicationStatus;
        this.creationDateTime = builder.creationDateTime;
        this.failureReasons = builder.failureReasons;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final BotVersionReplicationStatus botVersionReplicationStatus() {
        return BotVersionReplicationStatus.fromValue(this.botVersionReplicationStatus);
    }

    public final String botVersionReplicationStatusAsString() {
        return this.botVersionReplicationStatus;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersionReplicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotVersionReplicaSummary)) {
            return false;
        }
        BotVersionReplicaSummary other = (BotVersionReplicaSummary)obj;
        return Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.botVersionReplicationStatusAsString(), other.botVersionReplicationStatusAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons());
    }

    public final String toString() {
        return ToString.builder((String)"BotVersionReplicaSummary").add("BotVersion", (Object)this.botVersion()).add("BotVersionReplicationStatus", (Object)this.botVersionReplicationStatusAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "botVersionReplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.botVersionReplicationStatusAsString()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotVersionReplicaSummary, T> g) {
        return obj -> g.apply((BotVersionReplicaSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botVersion;
        private String botVersionReplicationStatus;
        private Instant creationDateTime;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BotVersionReplicaSummary model) {
            this.botVersion(model.botVersion);
            this.botVersionReplicationStatus(model.botVersionReplicationStatus);
            this.creationDateTime(model.creationDateTime);
            this.failureReasons(model.failureReasons);
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getBotVersionReplicationStatus() {
            return this.botVersionReplicationStatus;
        }

        public final void setBotVersionReplicationStatus(String botVersionReplicationStatus) {
            this.botVersionReplicationStatus = botVersionReplicationStatus;
        }

        @Override
        public final Builder botVersionReplicationStatus(String botVersionReplicationStatus) {
            this.botVersionReplicationStatus = botVersionReplicationStatus;
            return this;
        }

        @Override
        public final Builder botVersionReplicationStatus(BotVersionReplicationStatus botVersionReplicationStatus) {
            this.botVersionReplicationStatus(botVersionReplicationStatus == null ? null : botVersionReplicationStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public BotVersionReplicaSummary build() {
            return new BotVersionReplicaSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BotVersionReplicaSummary> {
        public Builder botVersion(String var1);

        public Builder botVersionReplicationStatus(String var1);

        public Builder botVersionReplicationStatus(BotVersionReplicationStatus var1);

        public Builder creationDateTime(Instant var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);
    }
}

