/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKeysCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupByKey;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupByKeysCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetricResult;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetricResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyticsIntentResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyticsIntentResult> {
    private static final SdkField<List<AnalyticsBinKey>> BIN_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("binKeys").getter(AnalyticsIntentResult.getter(AnalyticsIntentResult::binKeys)).setter(AnalyticsIntentResult.setter(Builder::binKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsBinKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsIntentGroupByKey>> GROUP_BY_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupByKeys").getter(AnalyticsIntentResult.getter(AnalyticsIntentResult::groupByKeys)).setter(AnalyticsIntentResult.setter(Builder::groupByKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupByKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentGroupByKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsIntentMetricResult>> METRICS_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricsResults").getter(AnalyticsIntentResult.getter(AnalyticsIntentResult::metricsResults)).setter(AnalyticsIntentResult.setter(Builder::metricsResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentMetricResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIN_KEYS_FIELD, GROUP_BY_KEYS_FIELD, METRICS_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AnalyticsBinKey> binKeys;
    private final List<AnalyticsIntentGroupByKey> groupByKeys;
    private final List<AnalyticsIntentMetricResult> metricsResults;

    private AnalyticsIntentResult(BuilderImpl builder) {
        this.binKeys = builder.binKeys;
        this.groupByKeys = builder.groupByKeys;
        this.metricsResults = builder.metricsResults;
    }

    public final boolean hasBinKeys() {
        return this.binKeys != null && !(this.binKeys instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsBinKey> binKeys() {
        return this.binKeys;
    }

    public final boolean hasGroupByKeys() {
        return this.groupByKeys != null && !(this.groupByKeys instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentGroupByKey> groupByKeys() {
        return this.groupByKeys;
    }

    public final boolean hasMetricsResults() {
        return this.metricsResults != null && !(this.metricsResults instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentMetricResult> metricsResults() {
        return this.metricsResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinKeys() ? this.binKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByKeys() ? this.groupByKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricsResults() ? this.metricsResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsIntentResult)) {
            return false;
        }
        AnalyticsIntentResult other = (AnalyticsIntentResult)obj;
        return this.hasBinKeys() == other.hasBinKeys() && Objects.equals(this.binKeys(), other.binKeys()) && this.hasGroupByKeys() == other.hasGroupByKeys() && Objects.equals(this.groupByKeys(), other.groupByKeys()) && this.hasMetricsResults() == other.hasMetricsResults() && Objects.equals(this.metricsResults(), other.metricsResults());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyticsIntentResult").add("BinKeys", this.hasBinKeys() ? this.binKeys() : null).add("GroupByKeys", this.hasGroupByKeys() ? this.groupByKeys() : null).add("MetricsResults", this.hasMetricsResults() ? this.metricsResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "binKeys": {
                return Optional.ofNullable(clazz.cast(this.binKeys()));
            }
            case "groupByKeys": {
                return Optional.ofNullable(clazz.cast(this.groupByKeys()));
            }
            case "metricsResults": {
                return Optional.ofNullable(clazz.cast(this.metricsResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsIntentResult, T> g) {
        return obj -> g.apply((AnalyticsIntentResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AnalyticsBinKey> binKeys = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsIntentGroupByKey> groupByKeys = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsIntentMetricResult> metricsResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsIntentResult model) {
            this.binKeys(model.binKeys);
            this.groupByKeys(model.groupByKeys);
            this.metricsResults(model.metricsResults);
        }

        public final List<AnalyticsBinKey.Builder> getBinKeys() {
            List<AnalyticsBinKey.Builder> result = AnalyticsBinKeysCopier.copyToBuilder(this.binKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinKeys(Collection<AnalyticsBinKey.BuilderImpl> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copyFromBuilder(binKeys);
        }

        @Override
        public final Builder binKeys(Collection<AnalyticsBinKey> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copy(binKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(AnalyticsBinKey ... binKeys) {
            this.binKeys(Arrays.asList(binKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(Consumer<AnalyticsBinKey.Builder> ... binKeys) {
            this.binKeys(Stream.of(binKeys).map(c -> (AnalyticsBinKey)((AnalyticsBinKey.Builder)AnalyticsBinKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentGroupByKey.Builder> getGroupByKeys() {
            List<AnalyticsIntentGroupByKey.Builder> result = AnalyticsIntentGroupByKeysCopier.copyToBuilder(this.groupByKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByKeys(Collection<AnalyticsIntentGroupByKey.BuilderImpl> groupByKeys) {
            this.groupByKeys = AnalyticsIntentGroupByKeysCopier.copyFromBuilder(groupByKeys);
        }

        @Override
        public final Builder groupByKeys(Collection<AnalyticsIntentGroupByKey> groupByKeys) {
            this.groupByKeys = AnalyticsIntentGroupByKeysCopier.copy(groupByKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(AnalyticsIntentGroupByKey ... groupByKeys) {
            this.groupByKeys(Arrays.asList(groupByKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(Consumer<AnalyticsIntentGroupByKey.Builder> ... groupByKeys) {
            this.groupByKeys(Stream.of(groupByKeys).map(c -> (AnalyticsIntentGroupByKey)((AnalyticsIntentGroupByKey.Builder)AnalyticsIntentGroupByKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentMetricResult.Builder> getMetricsResults() {
            List<AnalyticsIntentMetricResult.Builder> result = AnalyticsIntentMetricResultsCopier.copyToBuilder(this.metricsResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsResults(Collection<AnalyticsIntentMetricResult.BuilderImpl> metricsResults) {
            this.metricsResults = AnalyticsIntentMetricResultsCopier.copyFromBuilder(metricsResults);
        }

        @Override
        public final Builder metricsResults(Collection<AnalyticsIntentMetricResult> metricsResults) {
            this.metricsResults = AnalyticsIntentMetricResultsCopier.copy(metricsResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(AnalyticsIntentMetricResult ... metricsResults) {
            this.metricsResults(Arrays.asList(metricsResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(Consumer<AnalyticsIntentMetricResult.Builder> ... metricsResults) {
            this.metricsResults(Stream.of(metricsResults).map(c -> (AnalyticsIntentMetricResult)((AnalyticsIntentMetricResult.Builder)AnalyticsIntentMetricResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnalyticsIntentResult build() {
            return new AnalyticsIntentResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyticsIntentResult> {
        public Builder binKeys(Collection<AnalyticsBinKey> var1);

        public Builder binKeys(AnalyticsBinKey ... var1);

        public Builder binKeys(Consumer<AnalyticsBinKey.Builder> ... var1);

        public Builder groupByKeys(Collection<AnalyticsIntentGroupByKey> var1);

        public Builder groupByKeys(AnalyticsIntentGroupByKey ... var1);

        public Builder groupByKeys(Consumer<AnalyticsIntentGroupByKey.Builder> ... var1);

        public Builder metricsResults(Collection<AnalyticsIntentMetricResult> var1);

        public Builder metricsResults(AnalyticsIntentMetricResult ... var1);

        public Builder metricsResults(Consumer<AnalyticsIntentMetricResult.Builder> ... var1);
    }
}

