/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains results that are output for the user turn by the test execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserTurnOutputSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<UserTurnOutputSpecification.Builder, UserTurnOutputSpecification> {
    private static final SdkField<UserTurnIntentOutput> INTENT_FIELD = SdkField
            .<UserTurnIntentOutput> builder(MarshallingType.SDK_POJO).memberName("intent")
            .getter(getter(UserTurnOutputSpecification::intent)).setter(setter(Builder::intent))
            .constructor(UserTurnIntentOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()).build();

    private static final SdkField<List<ActiveContext>> ACTIVE_CONTEXTS_FIELD = SdkField
            .<List<ActiveContext>> builder(MarshallingType.LIST)
            .memberName("activeContexts")
            .getter(getter(UserTurnOutputSpecification::activeContexts))
            .setter(setter(Builder::activeContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActiveContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActiveContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transcript").getter(getter(UserTurnOutputSpecification::transcript)).setter(setter(Builder::transcript))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcript").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_FIELD,
            ACTIVE_CONTEXTS_FIELD, TRANSCRIPT_FIELD));

    private static final long serialVersionUID = 1L;

    private final UserTurnIntentOutput intent;

    private final List<ActiveContext> activeContexts;

    private final String transcript;

    private UserTurnOutputSpecification(BuilderImpl builder) {
        this.intent = builder.intent;
        this.activeContexts = builder.activeContexts;
        this.transcript = builder.transcript;
    }

    /**
     * <p>
     * Contains information about the intent.
     * </p>
     * 
     * @return Contains information about the intent.
     */
    public final UserTurnIntentOutput intent() {
        return intent;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActiveContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActiveContexts() {
        return activeContexts != null && !(activeContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contexts that are active in the turn.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActiveContexts} method.
     * </p>
     * 
     * @return The contexts that are active in the turn.
     */
    public final List<ActiveContext> activeContexts() {
        return activeContexts;
    }

    /**
     * <p>
     * The transcript that is output for the user turn by the test execution.
     * </p>
     * 
     * @return The transcript that is output for the user turn by the test execution.
     */
    public final String transcript() {
        return transcript;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intent());
        hashCode = 31 * hashCode + Objects.hashCode(hasActiveContexts() ? activeContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnOutputSpecification)) {
            return false;
        }
        UserTurnOutputSpecification other = (UserTurnOutputSpecification) obj;
        return Objects.equals(intent(), other.intent()) && hasActiveContexts() == other.hasActiveContexts()
                && Objects.equals(activeContexts(), other.activeContexts()) && Objects.equals(transcript(), other.transcript());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserTurnOutputSpecification").add("Intent", intent())
                .add("ActiveContexts", hasActiveContexts() ? activeContexts() : null).add("Transcript", transcript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intent":
            return Optional.ofNullable(clazz.cast(intent()));
        case "activeContexts":
            return Optional.ofNullable(clazz.cast(activeContexts()));
        case "transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserTurnOutputSpecification, T> g) {
        return obj -> g.apply((UserTurnOutputSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserTurnOutputSpecification> {
        /**
         * <p>
         * Contains information about the intent.
         * </p>
         * 
         * @param intent
         *        Contains information about the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intent(UserTurnIntentOutput intent);

        /**
         * <p>
         * Contains information about the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserTurnIntentOutput.Builder} avoiding
         * the need to create one manually via {@link UserTurnIntentOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserTurnIntentOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #intent(UserTurnIntentOutput)}.
         * 
         * @param intent
         *        a consumer that will call methods on {@link UserTurnIntentOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intent(UserTurnIntentOutput)
         */
        default Builder intent(Consumer<UserTurnIntentOutput.Builder> intent) {
            return intent(UserTurnIntentOutput.builder().applyMutation(intent).build());
        }

        /**
         * <p>
         * The contexts that are active in the turn.
         * </p>
         * 
         * @param activeContexts
         *        The contexts that are active in the turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(Collection<ActiveContext> activeContexts);

        /**
         * <p>
         * The contexts that are active in the turn.
         * </p>
         * 
         * @param activeContexts
         *        The contexts that are active in the turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(ActiveContext... activeContexts);

        /**
         * <p>
         * The contexts that are active in the turn.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext.Builder#build()} is called immediately
         * and its result is passed to {@link #activeContexts(List<ActiveContext>)}.
         * 
         * @param activeContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeContexts(java.util.Collection<ActiveContext>)
         */
        Builder activeContexts(Consumer<ActiveContext.Builder>... activeContexts);

        /**
         * <p>
         * The transcript that is output for the user turn by the test execution.
         * </p>
         * 
         * @param transcript
         *        The transcript that is output for the user turn by the test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(String transcript);
    }

    static final class BuilderImpl implements Builder {
        private UserTurnIntentOutput intent;

        private List<ActiveContext> activeContexts = DefaultSdkAutoConstructList.getInstance();

        private String transcript;

        private BuilderImpl() {
        }

        private BuilderImpl(UserTurnOutputSpecification model) {
            intent(model.intent);
            activeContexts(model.activeContexts);
            transcript(model.transcript);
        }

        public final UserTurnIntentOutput.Builder getIntent() {
            return intent != null ? intent.toBuilder() : null;
        }

        public final void setIntent(UserTurnIntentOutput.BuilderImpl intent) {
            this.intent = intent != null ? intent.build() : null;
        }

        @Override
        public final Builder intent(UserTurnIntentOutput intent) {
            this.intent = intent;
            return this;
        }

        public final List<ActiveContext.Builder> getActiveContexts() {
            List<ActiveContext.Builder> result = ActiveContextListCopier.copyToBuilder(this.activeContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveContexts(Collection<ActiveContext.BuilderImpl> activeContexts) {
            this.activeContexts = ActiveContextListCopier.copyFromBuilder(activeContexts);
        }

        @Override
        public final Builder activeContexts(Collection<ActiveContext> activeContexts) {
            this.activeContexts = ActiveContextListCopier.copy(activeContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(ActiveContext... activeContexts) {
            activeContexts(Arrays.asList(activeContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(Consumer<ActiveContext.Builder>... activeContexts) {
            activeContexts(Stream.of(activeContexts).map(c -> ActiveContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTranscript() {
            return transcript;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        @Override
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        @Override
        public UserTurnOutputSpecification build() {
            return new UserTurnOutputSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
