/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class TestResultMatchStatusCountMapCopier {
    static Map<String, Integer> copy(Map<String, Integer> testResultMatchStatusCountMapParam) {
        Map<String, Integer> map;
        if (testResultMatchStatusCountMapParam == null || testResultMatchStatusCountMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Integer> modifiableMap = new LinkedHashMap<>();
            testResultMatchStatusCountMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Integer> copyEnumToString(Map<TestResultMatchStatus, Integer> testResultMatchStatusCountMapParam) {
        Map<String, Integer> map;
        if (testResultMatchStatusCountMapParam == null || testResultMatchStatusCountMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Integer> modifiableMap = new LinkedHashMap<>();
            testResultMatchStatusCountMapParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<TestResultMatchStatus, Integer> copyStringToEnum(Map<String, Integer> testResultMatchStatusCountMapParam) {
        Map<TestResultMatchStatus, Integer> map;
        if (testResultMatchStatusCountMapParam == null || testResultMatchStatusCountMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<TestResultMatchStatus, Integer> modifiableMap = new LinkedHashMap<>();
            testResultMatchStatusCountMapParam.forEach((key, value) -> {
                TestResultMatchStatus result = TestResultMatchStatus.fromValue(key);
                if (result != TestResultMatchStatus.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
