/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopBotRecommendationResponse extends LexModelsV2Response implements
        ToCopyableBuilder<StopBotRecommendationResponse.Builder, StopBotRecommendationResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(StopBotRecommendationResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(StopBotRecommendationResponse::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(StopBotRecommendationResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> BOT_RECOMMENDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botRecommendationStatus").getter(getter(StopBotRecommendationResponse::botRecommendationStatusAsString))
            .setter(setter(Builder::botRecommendationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationStatus").build())
            .build();

    private static final SdkField<String> BOT_RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botRecommendationId").getter(getter(StopBotRecommendationResponse::botRecommendationId))
            .setter(setter(Builder::botRecommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_RECOMMENDATION_STATUS_FIELD, BOT_RECOMMENDATION_ID_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String botRecommendationStatus;

    private final String botRecommendationId;

    private StopBotRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botRecommendationStatus = builder.botRecommendationStatus;
        this.botRecommendationId = builder.botRecommendationId;
    }

    /**
     * <p>
     * The unique identifier of the bot containing the bot recommendation that is being stopped.
     * </p>
     * 
     * @return The unique identifier of the bot containing the bot recommendation that is being stopped.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot containing the recommendation that is being stopped.
     * </p>
     * 
     * @return The version of the bot containing the recommendation that is being stopped.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale of the bot response to stop. The string must match one of the supported
     * locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
     * </p>
     * 
     * @return The identifier of the language and locale of the bot response to stop. The string must match one of the
     *         supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the
     * failureReasons field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #botRecommendationStatus} will return {@link BotRecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #botRecommendationStatusAsString}.
     * </p>
     * 
     * @return The status of the bot recommendation. If the status is Failed, then the reasons for the failure are
     *         listed in the failureReasons field.
     * @see BotRecommendationStatus
     */
    public final BotRecommendationStatus botRecommendationStatus() {
        return BotRecommendationStatus.fromValue(botRecommendationStatus);
    }

    /**
     * <p>
     * The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the
     * failureReasons field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #botRecommendationStatus} will return {@link BotRecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #botRecommendationStatusAsString}.
     * </p>
     * 
     * @return The status of the bot recommendation. If the status is Failed, then the reasons for the failure are
     *         listed in the failureReasons field.
     * @see BotRecommendationStatus
     */
    public final String botRecommendationStatusAsString() {
        return botRecommendationStatus;
    }

    /**
     * <p>
     * The unique identifier of the bot recommendation that is being stopped.
     * </p>
     * 
     * @return The unique identifier of the bot recommendation that is being stopped.
     */
    public final String botRecommendationId() {
        return botRecommendationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(botRecommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(botRecommendationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopBotRecommendationResponse)) {
            return false;
        }
        StopBotRecommendationResponse other = (StopBotRecommendationResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && Objects.equals(botRecommendationStatusAsString(), other.botRecommendationStatusAsString())
                && Objects.equals(botRecommendationId(), other.botRecommendationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopBotRecommendationResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("BotRecommendationStatus", botRecommendationStatusAsString())
                .add("BotRecommendationId", botRecommendationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "botRecommendationStatus":
            return Optional.ofNullable(clazz.cast(botRecommendationStatusAsString()));
        case "botRecommendationId":
            return Optional.ofNullable(clazz.cast(botRecommendationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopBotRecommendationResponse, T> g) {
        return obj -> g.apply((StopBotRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, StopBotRecommendationResponse> {
        /**
         * <p>
         * The unique identifier of the bot containing the bot recommendation that is being stopped.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot containing the bot recommendation that is being stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot containing the recommendation that is being stopped.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot containing the recommendation that is being stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale of the bot response to stop. The string must match one of the
         * supported locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the bot response to stop. The string must match one of
         *        the supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in
         * the failureReasons field.
         * </p>
         * 
         * @param botRecommendationStatus
         *        The status of the bot recommendation. If the status is Failed, then the reasons for the failure are
         *        listed in the failureReasons field.
         * @see BotRecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotRecommendationStatus
         */
        Builder botRecommendationStatus(String botRecommendationStatus);

        /**
         * <p>
         * The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in
         * the failureReasons field.
         * </p>
         * 
         * @param botRecommendationStatus
         *        The status of the bot recommendation. If the status is Failed, then the reasons for the failure are
         *        listed in the failureReasons field.
         * @see BotRecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotRecommendationStatus
         */
        Builder botRecommendationStatus(BotRecommendationStatus botRecommendationStatus);

        /**
         * <p>
         * The unique identifier of the bot recommendation that is being stopped.
         * </p>
         * 
         * @param botRecommendationId
         *        The unique identifier of the bot recommendation that is being stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botRecommendationId(String botRecommendationId);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String botRecommendationStatus;

        private String botRecommendationId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopBotRecommendationResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            botRecommendationStatus(model.botRecommendationStatus);
            botRecommendationId(model.botRecommendationId);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotRecommendationStatus() {
            return botRecommendationStatus;
        }

        public final void setBotRecommendationStatus(String botRecommendationStatus) {
            this.botRecommendationStatus = botRecommendationStatus;
        }

        @Override
        public final Builder botRecommendationStatus(String botRecommendationStatus) {
            this.botRecommendationStatus = botRecommendationStatus;
            return this;
        }

        @Override
        public final Builder botRecommendationStatus(BotRecommendationStatus botRecommendationStatus) {
            this.botRecommendationStatus(botRecommendationStatus == null ? null : botRecommendationStatus.toString());
            return this;
        }

        public final String getBotRecommendationId() {
            return botRecommendationId;
        }

        public final void setBotRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
        }

        @Override
        public final Builder botRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
            return this;
        }

        @Override
        public StopBotRecommendationResponse build() {
            return new StopBotRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
