/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAssociatedTranscriptsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<SearchAssociatedTranscriptsResponse.Builder, SearchAssociatedTranscriptsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(SearchAssociatedTranscriptsResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(SearchAssociatedTranscriptsResponse::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(SearchAssociatedTranscriptsResponse::localeId))
            .setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> BOT_RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botRecommendationId").getter(getter(SearchAssociatedTranscriptsResponse::botRecommendationId))
            .setter(setter(Builder::botRecommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationId").build())
            .build();

    private static final SdkField<Integer> NEXT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nextIndex").getter(getter(SearchAssociatedTranscriptsResponse::nextIndex))
            .setter(setter(Builder::nextIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextIndex").build()).build();

    private static final SdkField<List<AssociatedTranscript>> ASSOCIATED_TRANSCRIPTS_FIELD = SdkField
            .<List<AssociatedTranscript>> builder(MarshallingType.LIST)
            .memberName("associatedTranscripts")
            .getter(getter(SearchAssociatedTranscriptsResponse::associatedTranscripts))
            .setter(setter(Builder::associatedTranscripts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedTranscripts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociatedTranscript> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedTranscript::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResults").getter(getter(SearchAssociatedTranscriptsResponse::totalResults))
            .setter(setter(Builder::totalResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_RECOMMENDATION_ID_FIELD, NEXT_INDEX_FIELD, ASSOCIATED_TRANSCRIPTS_FIELD,
            TOTAL_RESULTS_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String botRecommendationId;

    private final Integer nextIndex;

    private final List<AssociatedTranscript> associatedTranscripts;

    private final Integer totalResults;

    private SearchAssociatedTranscriptsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botRecommendationId = builder.botRecommendationId;
        this.nextIndex = builder.nextIndex;
        this.associatedTranscripts = builder.associatedTranscripts;
        this.totalResults = builder.totalResults;
    }

    /**
     * <p>
     * The unique identifier of the bot associated with the transcripts that you are searching.
     * </p>
     * 
     * @return The unique identifier of the bot associated with the transcripts that you are searching.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot containing the transcripts that you are searching.
     * </p>
     * 
     * @return The version of the bot containing the transcripts that you are searching.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale of the transcripts to search. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
     * </p>
     * 
     * @return The identifier of the language and locale of the transcripts to search. The string must match one of the
     *         supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The unique identifier of the bot recommendation associated with the transcripts to search.
     * </p>
     * 
     * @return The unique identifier of the bot recommendation associated with the transcripts to search.
     */
    public final String botRecommendationId() {
        return botRecommendationId;
    }

    /**
     * <p>
     * A index that indicates whether there are more results to return in a response to the SearchAssociatedTranscripts
     * operation. If the nextIndex field is present, you send the contents as the nextIndex parameter of a
     * SearchAssociatedTranscriptsRequest operation to get the next page of results.
     * </p>
     * 
     * @return A index that indicates whether there are more results to return in a response to the
     *         SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the
     *         nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.
     */
    public final Integer nextIndex() {
        return nextIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedTranscripts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedTranscripts() {
        return associatedTranscripts != null && !(associatedTranscripts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The object that contains the associated transcript that meet the criteria you specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedTranscripts} method.
     * </p>
     * 
     * @return The object that contains the associated transcript that meet the criteria you specified.
     */
    public final List<AssociatedTranscript> associatedTranscripts() {
        return associatedTranscripts;
    }

    /**
     * <p>
     * The total number of transcripts returned by the search.
     * </p>
     * 
     * @return The total number of transcripts returned by the search.
     */
    public final Integer totalResults() {
        return totalResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(botRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(nextIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedTranscripts() ? associatedTranscripts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAssociatedTranscriptsResponse)) {
            return false;
        }
        SearchAssociatedTranscriptsResponse other = (SearchAssociatedTranscriptsResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && Objects.equals(botRecommendationId(), other.botRecommendationId())
                && Objects.equals(nextIndex(), other.nextIndex())
                && hasAssociatedTranscripts() == other.hasAssociatedTranscripts()
                && Objects.equals(associatedTranscripts(), other.associatedTranscripts())
                && Objects.equals(totalResults(), other.totalResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchAssociatedTranscriptsResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("BotRecommendationId", botRecommendationId()).add("NextIndex", nextIndex())
                .add("AssociatedTranscripts", hasAssociatedTranscripts() ? associatedTranscripts() : null)
                .add("TotalResults", totalResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "botRecommendationId":
            return Optional.ofNullable(clazz.cast(botRecommendationId()));
        case "nextIndex":
            return Optional.ofNullable(clazz.cast(nextIndex()));
        case "associatedTranscripts":
            return Optional.ofNullable(clazz.cast(associatedTranscripts()));
        case "totalResults":
            return Optional.ofNullable(clazz.cast(totalResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAssociatedTranscriptsResponse, T> g) {
        return obj -> g.apply((SearchAssociatedTranscriptsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchAssociatedTranscriptsResponse> {
        /**
         * <p>
         * The unique identifier of the bot associated with the transcripts that you are searching.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot associated with the transcripts that you are searching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot containing the transcripts that you are searching.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot containing the transcripts that you are searching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale of the transcripts to search. The string must match one of the
         * supported locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the transcripts to search. The string must match one of
         *        the supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The unique identifier of the bot recommendation associated with the transcripts to search.
         * </p>
         * 
         * @param botRecommendationId
         *        The unique identifier of the bot recommendation associated with the transcripts to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botRecommendationId(String botRecommendationId);

        /**
         * <p>
         * A index that indicates whether there are more results to return in a response to the
         * SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the
         * nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.
         * </p>
         * 
         * @param nextIndex
         *        A index that indicates whether there are more results to return in a response to the
         *        SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the
         *        nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextIndex(Integer nextIndex);

        /**
         * <p>
         * The object that contains the associated transcript that meet the criteria you specified.
         * </p>
         * 
         * @param associatedTranscripts
         *        The object that contains the associated transcript that meet the criteria you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedTranscripts(Collection<AssociatedTranscript> associatedTranscripts);

        /**
         * <p>
         * The object that contains the associated transcript that meet the criteria you specified.
         * </p>
         * 
         * @param associatedTranscripts
         *        The object that contains the associated transcript that meet the criteria you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedTranscripts(AssociatedTranscript... associatedTranscripts);

        /**
         * <p>
         * The object that contains the associated transcript that meet the criteria you specified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript.Builder#build()} is called
         * immediately and its result is passed to {@link #associatedTranscripts(List<AssociatedTranscript>)}.
         * 
         * @param associatedTranscripts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AssociatedTranscript.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedTranscripts(java.util.Collection<AssociatedTranscript>)
         */
        Builder associatedTranscripts(Consumer<AssociatedTranscript.Builder>... associatedTranscripts);

        /**
         * <p>
         * The total number of transcripts returned by the search.
         * </p>
         * 
         * @param totalResults
         *        The total number of transcripts returned by the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResults(Integer totalResults);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String botRecommendationId;

        private Integer nextIndex;

        private List<AssociatedTranscript> associatedTranscripts = DefaultSdkAutoConstructList.getInstance();

        private Integer totalResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAssociatedTranscriptsResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            botRecommendationId(model.botRecommendationId);
            nextIndex(model.nextIndex);
            associatedTranscripts(model.associatedTranscripts);
            totalResults(model.totalResults);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotRecommendationId() {
            return botRecommendationId;
        }

        public final void setBotRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
        }

        @Override
        public final Builder botRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
            return this;
        }

        public final Integer getNextIndex() {
            return nextIndex;
        }

        public final void setNextIndex(Integer nextIndex) {
            this.nextIndex = nextIndex;
        }

        @Override
        public final Builder nextIndex(Integer nextIndex) {
            this.nextIndex = nextIndex;
            return this;
        }

        public final List<AssociatedTranscript.Builder> getAssociatedTranscripts() {
            List<AssociatedTranscript.Builder> result = AssociatedTranscriptListCopier.copyToBuilder(this.associatedTranscripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedTranscripts(Collection<AssociatedTranscript.BuilderImpl> associatedTranscripts) {
            this.associatedTranscripts = AssociatedTranscriptListCopier.copyFromBuilder(associatedTranscripts);
        }

        @Override
        public final Builder associatedTranscripts(Collection<AssociatedTranscript> associatedTranscripts) {
            this.associatedTranscripts = AssociatedTranscriptListCopier.copy(associatedTranscripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedTranscripts(AssociatedTranscript... associatedTranscripts) {
            associatedTranscripts(Arrays.asList(associatedTranscripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedTranscripts(Consumer<AssociatedTranscript.Builder>... associatedTranscripts) {
            associatedTranscripts(Stream.of(associatedTranscripts)
                    .map(c -> AssociatedTranscript.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalResults() {
            return totalResults;
        }

        public final void setTotalResults(Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public final Builder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @Override
        public SearchAssociatedTranscriptsResponse build() {
            return new SearchAssociatedTranscriptsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
