/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImportsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListImportsRequest.Builder, ListImportsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListImportsRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListImportsRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<ImportSortBy> SORT_BY_FIELD = SdkField.<ImportSortBy> builder(MarshallingType.SDK_POJO)
            .memberName("sortBy").getter(getter(ListImportsRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(ImportSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<List<ImportFilter>> FILTERS_FIELD = SdkField
            .<List<ImportFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListImportsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListImportsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImportsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListImportsRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, SORT_BY_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, LOCALE_ID_FIELD));

    private final String botId;

    private final String botVersion;

    private final ImportSortBy sortBy;

    private final List<ImportFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final String localeId;

    private ListImportsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.sortBy = builder.sortBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.localeId = builder.localeId;
    }

    /**
     * <p>
     * The unique identifier that Amazon Lex assigned to the bot.
     * </p>
     * 
     * @return The unique identifier that Amazon Lex assigned to the bot.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot to list imports for.
     * </p>
     * 
     * @return The version of the bot to list imports for.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code>
     * field in ascending or descending order.
     * </p>
     * 
     * @return Determines the field that the list of imports is sorted by. You can sort by the
     *         <code>LastUpdatedDateTime</code> field in ascending or descending order.
     */
    public final ImportSortBy sortBy() {
        return sortBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the specification of a filter used to limit the bots in the response to only those that match the filter
     * specification. You can only specify one filter and one string to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Provides the specification of a filter used to limit the bots in the response to only those that match
     *         the filter specification. You can only specify one filter and one string to filter on.
     */
    public final List<ImportFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of imports to return in each page of results. If there are fewer results than the max page
     * size, only the actual number of results are returned.
     * </p>
     * 
     * @return The maximum number of imports to return in each page of results. If there are fewer results than the max
     *         page size, only the actual number of results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the <code>ListImports</code> operation contains more results than specified in the
     * <code>maxResults</code> parameter, a token is returned in the response.
     * </p>
     * <p>
     * Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return
     * the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the
     * <code>nextToken</code> returned in the response is null.
     * </p>
     * 
     * @return If the response from the <code>ListImports</code> operation contains more results than specified in the
     *         <code>maxResults</code> parameter, a token is returned in the response.</p>
     *         <p>
     *         Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to
     *         return the next page of results. For a complete set of results, call the <code>ListImports</code>
     *         operation until the <code>nextToken</code> returned in the response is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the locale that should be present in the list. If you don't specify a resource type in the
     * <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.
     * </p>
     * 
     * @return Specifies the locale that should be present in the list. If you don't specify a resource type in the
     *         <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.
     */
    public final String localeId() {
        return localeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsRequest)) {
            return false;
        }
        ListImportsRequest other = (ListImportsRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(sortBy(), other.sortBy()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(localeId(), other.localeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImportsRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("SortBy", sortBy()).add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("LocaleId", localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImportsRequest, T> g) {
        return obj -> g.apply((ListImportsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListImportsRequest> {
        /**
         * <p>
         * The unique identifier that Amazon Lex assigned to the bot.
         * </p>
         * 
         * @param botId
         *        The unique identifier that Amazon Lex assigned to the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot to list imports for.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot to list imports for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * Determines the field that the list of imports is sorted by. You can sort by the
         * <code>LastUpdatedDateTime</code> field in ascending or descending order.
         * </p>
         * 
         * @param sortBy
         *        Determines the field that the list of imports is sorted by. You can sort by the
         *        <code>LastUpdatedDateTime</code> field in ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(ImportSortBy sortBy);

        /**
         * <p>
         * Determines the field that the list of imports is sorted by. You can sort by the
         * <code>LastUpdatedDateTime</code> field in ascending or descending order.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportSortBy.Builder} avoiding the need
         * to create one manually via {@link ImportSortBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportSortBy.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(ImportSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link ImportSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(ImportSortBy)
         */
        default Builder sortBy(Consumer<ImportSortBy.Builder> sortBy) {
            return sortBy(ImportSortBy.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * Provides the specification of a filter used to limit the bots in the response to only those that match the
         * filter specification. You can only specify one filter and one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the bots in the response to only those that match
         *        the filter specification. You can only specify one filter and one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ImportFilter> filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the bots in the response to only those that match the
         * filter specification. You can only specify one filter and one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the bots in the response to only those that match
         *        the filter specification. You can only specify one filter and one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ImportFilter... filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the bots in the response to only those that match the
         * filter specification. You can only specify one filter and one string to filter on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ImportFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.ImportFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ImportFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<ImportFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ImportFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<ImportFilter>)
         */
        Builder filters(Consumer<ImportFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of imports to return in each page of results. If there are fewer results than the max page
         * size, only the actual number of results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of imports to return in each page of results. If there are fewer results than the
         *        max page size, only the actual number of results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the <code>ListImports</code> operation contains more results than specified in the
         * <code>maxResults</code> parameter, a token is returned in the response.
         * </p>
         * <p>
         * Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to
         * return the next page of results. For a complete set of results, call the <code>ListImports</code> operation
         * until the <code>nextToken</code> returned in the response is null.
         * </p>
         * 
         * @param nextToken
         *        If the response from the <code>ListImports</code> operation contains more results than specified in
         *        the <code>maxResults</code> parameter, a token is returned in the response.</p>
         *        <p>
         *        Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request
         *        to return the next page of results. For a complete set of results, call the <code>ListImports</code>
         *        operation until the <code>nextToken</code> returned in the response is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the locale that should be present in the list. If you don't specify a resource type in the
         * <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.
         * </p>
         * 
         * @param localeId
         *        Specifies the locale that should be present in the list. If you don't specify a resource type in the
         *        <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private ImportSortBy sortBy;

        private List<ImportFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            sortBy(model.sortBy);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            localeId(model.localeId);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final ImportSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(ImportSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(ImportSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final List<ImportFilter.Builder> getFilters() {
            List<ImportFilter.Builder> result = ImportFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ImportFilter.BuilderImpl> filters) {
            this.filters = ImportFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ImportFilter> filters) {
            this.filters = ImportFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ImportFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ImportFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ImportFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListImportsRequest build() {
            return new ListImportsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
