/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The unique custom vocabulary item from the custom vocabulary list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomVocabularyItem implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomVocabularyItem.Builder, CustomVocabularyItem> {
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("itemId")
            .getter(getter(CustomVocabularyItem::itemId)).setter(setter(Builder::itemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()).build();

    private static final SdkField<String> PHRASE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("phrase")
            .getter(getter(CustomVocabularyItem::phrase)).setter(setter(Builder::phrase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phrase").build()).build();

    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("weight").getter(getter(CustomVocabularyItem::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weight").build()).build();

    private static final SdkField<String> DISPLAY_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayAs").getter(getter(CustomVocabularyItem::displayAs)).setter(setter(Builder::displayAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayAs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_ID_FIELD, PHRASE_FIELD,
            WEIGHT_FIELD, DISPLAY_AS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String itemId;

    private final String phrase;

    private final Integer weight;

    private final String displayAs;

    private CustomVocabularyItem(BuilderImpl builder) {
        this.itemId = builder.itemId;
        this.phrase = builder.phrase;
        this.weight = builder.weight;
        this.displayAs = builder.displayAs;
    }

    /**
     * <p>
     * The unique item identifer for the custom vocabulary item from the custom vocabulary list.
     * </p>
     * 
     * @return The unique item identifer for the custom vocabulary item from the custom vocabulary list.
     */
    public final String itemId() {
        return itemId;
    }

    /**
     * <p>
     * The unique phrase for the custom vocabulary item from the custom vocabulary list.
     * </p>
     * 
     * @return The unique phrase for the custom vocabulary item from the custom vocabulary list.
     */
    public final String phrase() {
        return phrase;
    }

    /**
     * <p>
     * The weight assigned for the custom vocabulary item from the custom vocabulary list.
     * </p>
     * 
     * @return The weight assigned for the custom vocabulary item from the custom vocabulary list.
     */
    public final Integer weight() {
        return weight;
    }

    /**
     * <p>
     * The DisplayAs value for the custom vocabulary item from the custom vocabulary list.
     * </p>
     * 
     * @return The DisplayAs value for the custom vocabulary item from the custom vocabulary list.
     */
    public final String displayAs() {
        return displayAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemId());
        hashCode = 31 * hashCode + Objects.hashCode(phrase());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(displayAs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomVocabularyItem)) {
            return false;
        }
        CustomVocabularyItem other = (CustomVocabularyItem) obj;
        return Objects.equals(itemId(), other.itemId()) && Objects.equals(phrase(), other.phrase())
                && Objects.equals(weight(), other.weight()) && Objects.equals(displayAs(), other.displayAs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomVocabularyItem").add("ItemId", itemId()).add("Phrase", phrase()).add("Weight", weight())
                .add("DisplayAs", displayAs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemId":
            return Optional.ofNullable(clazz.cast(itemId()));
        case "phrase":
            return Optional.ofNullable(clazz.cast(phrase()));
        case "weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "displayAs":
            return Optional.ofNullable(clazz.cast(displayAs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomVocabularyItem, T> g) {
        return obj -> g.apply((CustomVocabularyItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomVocabularyItem> {
        /**
         * <p>
         * The unique item identifer for the custom vocabulary item from the custom vocabulary list.
         * </p>
         * 
         * @param itemId
         *        The unique item identifer for the custom vocabulary item from the custom vocabulary list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemId(String itemId);

        /**
         * <p>
         * The unique phrase for the custom vocabulary item from the custom vocabulary list.
         * </p>
         * 
         * @param phrase
         *        The unique phrase for the custom vocabulary item from the custom vocabulary list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phrase(String phrase);

        /**
         * <p>
         * The weight assigned for the custom vocabulary item from the custom vocabulary list.
         * </p>
         * 
         * @param weight
         *        The weight assigned for the custom vocabulary item from the custom vocabulary list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Integer weight);

        /**
         * <p>
         * The DisplayAs value for the custom vocabulary item from the custom vocabulary list.
         * </p>
         * 
         * @param displayAs
         *        The DisplayAs value for the custom vocabulary item from the custom vocabulary list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayAs(String displayAs);
    }

    static final class BuilderImpl implements Builder {
        private String itemId;

        private String phrase;

        private Integer weight;

        private String displayAs;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomVocabularyItem model) {
            itemId(model.itemId);
            phrase(model.phrase);
            weight(model.weight);
            displayAs(model.displayAs);
        }

        public final String getItemId() {
            return itemId;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final String getPhrase() {
            return phrase;
        }

        public final void setPhrase(String phrase) {
            this.phrase = phrase;
        }

        @Override
        public final Builder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public final Integer getWeight() {
            return weight;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public final String getDisplayAs() {
            return displayAs;
        }

        public final void setDisplayAs(String displayAs) {
            this.displayAs = displayAs;
        }

        @Override
        public final Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @Override
        public CustomVocabularyItem build() {
            return new CustomVocabularyItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
