/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The selected data source to filter the conversation log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversationLogsDataSourceFilterBy implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversationLogsDataSourceFilterBy.Builder, ConversationLogsDataSourceFilterBy> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ConversationLogsDataSourceFilterBy::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ConversationLogsDataSourceFilterBy::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> INPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputMode").getter(getter(ConversationLogsDataSourceFilterBy::inputModeAsString))
            .setter(setter(Builder::inputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, INPUT_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final Instant endTime;

    private final String inputMode;

    private ConversationLogsDataSourceFilterBy(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.inputMode = builder.inputMode;
    }

    /**
     * <p>
     * The start time for the conversation log.
     * </p>
     * 
     * @return The start time for the conversation log.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the conversation log.
     * </p>
     * 
     * @return The end time for the conversation log.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The selection to filter by input mode for the conversation logs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputMode} will
     * return {@link ConversationLogsInputModeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputModeAsString}.
     * </p>
     * 
     * @return The selection to filter by input mode for the conversation logs.
     * @see ConversationLogsInputModeFilter
     */
    public final ConversationLogsInputModeFilter inputMode() {
        return ConversationLogsInputModeFilter.fromValue(inputMode);
    }

    /**
     * <p>
     * The selection to filter by input mode for the conversation logs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputMode} will
     * return {@link ConversationLogsInputModeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputModeAsString}.
     * </p>
     * 
     * @return The selection to filter by input mode for the conversation logs.
     * @see ConversationLogsInputModeFilter
     */
    public final String inputModeAsString() {
        return inputMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(inputModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversationLogsDataSourceFilterBy)) {
            return false;
        }
        ConversationLogsDataSourceFilterBy other = (ConversationLogsDataSourceFilterBy) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(inputModeAsString(), other.inputModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversationLogsDataSourceFilterBy").add("StartTime", startTime()).add("EndTime", endTime())
                .add("InputMode", inputModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "inputMode":
            return Optional.ofNullable(clazz.cast(inputModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversationLogsDataSourceFilterBy, T> g) {
        return obj -> g.apply((ConversationLogsDataSourceFilterBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversationLogsDataSourceFilterBy> {
        /**
         * <p>
         * The start time for the conversation log.
         * </p>
         * 
         * @param startTime
         *        The start time for the conversation log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time for the conversation log.
         * </p>
         * 
         * @param endTime
         *        The end time for the conversation log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The selection to filter by input mode for the conversation logs.
         * </p>
         * 
         * @param inputMode
         *        The selection to filter by input mode for the conversation logs.
         * @see ConversationLogsInputModeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversationLogsInputModeFilter
         */
        Builder inputMode(String inputMode);

        /**
         * <p>
         * The selection to filter by input mode for the conversation logs.
         * </p>
         * 
         * @param inputMode
         *        The selection to filter by input mode for the conversation logs.
         * @see ConversationLogsInputModeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversationLogsInputModeFilter
         */
        Builder inputMode(ConversationLogsInputModeFilter inputMode);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private String inputMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversationLogsDataSourceFilterBy model) {
            startTime(model.startTime);
            endTime(model.endTime);
            inputMode(model.inputMode);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getInputMode() {
            return inputMode;
        }

        public final void setInputMode(String inputMode) {
            this.inputMode = inputMode;
        }

        @Override
        public final Builder inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        @Override
        public final Builder inputMode(ConversationLogsInputModeFilter inputMode) {
            this.inputMode(inputMode == null ? null : inputMode.toString());
            return this;
        }

        @Override
        public ConversationLogsDataSourceFilterBy build() {
            return new ConversationLogsDataSourceFilterBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
