/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the bot recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotRecommendationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BotRecommendationSummary.Builder, BotRecommendationSummary> {
    private static final SdkField<String> BOT_RECOMMENDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botRecommendationStatus").getter(getter(BotRecommendationSummary::botRecommendationStatusAsString))
            .setter(setter(Builder::botRecommendationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationStatus").build())
            .build();

    private static final SdkField<String> BOT_RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botRecommendationId").getter(getter(BotRecommendationSummary::botRecommendationId))
            .setter(setter(Builder::botRecommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationId").build())
            .build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(BotRecommendationSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(BotRecommendationSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(BOT_RECOMMENDATION_STATUS_FIELD, BOT_RECOMMENDATION_ID_FIELD,
                    CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String botRecommendationStatus;

    private final String botRecommendationId;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private BotRecommendationSummary(BuilderImpl builder) {
        this.botRecommendationStatus = builder.botRecommendationStatus;
        this.botRecommendationId = builder.botRecommendationId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The status of the bot recommendation.
     * </p>
     * <p>
     * If the status is Failed, then the reasons for the failure are listed in the failureReasons field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #botRecommendationStatus} will return {@link BotRecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #botRecommendationStatusAsString}.
     * </p>
     * 
     * @return The status of the bot recommendation.</p>
     *         <p>
     *         If the status is Failed, then the reasons for the failure are listed in the failureReasons field.
     * @see BotRecommendationStatus
     */
    public final BotRecommendationStatus botRecommendationStatus() {
        return BotRecommendationStatus.fromValue(botRecommendationStatus);
    }

    /**
     * <p>
     * The status of the bot recommendation.
     * </p>
     * <p>
     * If the status is Failed, then the reasons for the failure are listed in the failureReasons field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #botRecommendationStatus} will return {@link BotRecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #botRecommendationStatusAsString}.
     * </p>
     * 
     * @return The status of the bot recommendation.</p>
     *         <p>
     *         If the status is Failed, then the reasons for the failure are listed in the failureReasons field.
     * @see BotRecommendationStatus
     */
    public final String botRecommendationStatusAsString() {
        return botRecommendationStatus;
    }

    /**
     * <p>
     * The unique identifier of the bot recommendation to be updated.
     * </p>
     * 
     * @return The unique identifier of the bot recommendation to be updated.
     */
    public final String botRecommendationId() {
        return botRecommendationId;
    }

    /**
     * <p>
     * A timestamp of the date and time that the bot recommendation was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the bot recommendation was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * A timestamp of the date and time that the bot recommendation was last updated.
     * </p>
     * 
     * @return A timestamp of the date and time that the bot recommendation was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botRecommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(botRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotRecommendationSummary)) {
            return false;
        }
        BotRecommendationSummary other = (BotRecommendationSummary) obj;
        return Objects.equals(botRecommendationStatusAsString(), other.botRecommendationStatusAsString())
                && Objects.equals(botRecommendationId(), other.botRecommendationId())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotRecommendationSummary").add("BotRecommendationStatus", botRecommendationStatusAsString())
                .add("BotRecommendationId", botRecommendationId()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botRecommendationStatus":
            return Optional.ofNullable(clazz.cast(botRecommendationStatusAsString()));
        case "botRecommendationId":
            return Optional.ofNullable(clazz.cast(botRecommendationId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotRecommendationSummary, T> g) {
        return obj -> g.apply((BotRecommendationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotRecommendationSummary> {
        /**
         * <p>
         * The status of the bot recommendation.
         * </p>
         * <p>
         * If the status is Failed, then the reasons for the failure are listed in the failureReasons field.
         * </p>
         * 
         * @param botRecommendationStatus
         *        The status of the bot recommendation.</p>
         *        <p>
         *        If the status is Failed, then the reasons for the failure are listed in the failureReasons field.
         * @see BotRecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotRecommendationStatus
         */
        Builder botRecommendationStatus(String botRecommendationStatus);

        /**
         * <p>
         * The status of the bot recommendation.
         * </p>
         * <p>
         * If the status is Failed, then the reasons for the failure are listed in the failureReasons field.
         * </p>
         * 
         * @param botRecommendationStatus
         *        The status of the bot recommendation.</p>
         *        <p>
         *        If the status is Failed, then the reasons for the failure are listed in the failureReasons field.
         * @see BotRecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotRecommendationStatus
         */
        Builder botRecommendationStatus(BotRecommendationStatus botRecommendationStatus);

        /**
         * <p>
         * The unique identifier of the bot recommendation to be updated.
         * </p>
         * 
         * @param botRecommendationId
         *        The unique identifier of the bot recommendation to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botRecommendationId(String botRecommendationId);

        /**
         * <p>
         * A timestamp of the date and time that the bot recommendation was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the bot recommendation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A timestamp of the date and time that the bot recommendation was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the date and time that the bot recommendation was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String botRecommendationStatus;

        private String botRecommendationId;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BotRecommendationSummary model) {
            botRecommendationStatus(model.botRecommendationStatus);
            botRecommendationId(model.botRecommendationId);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getBotRecommendationStatus() {
            return botRecommendationStatus;
        }

        public final void setBotRecommendationStatus(String botRecommendationStatus) {
            this.botRecommendationStatus = botRecommendationStatus;
        }

        @Override
        public final Builder botRecommendationStatus(String botRecommendationStatus) {
            this.botRecommendationStatus = botRecommendationStatus;
            return this;
        }

        @Override
        public final Builder botRecommendationStatus(BotRecommendationStatus botRecommendationStatus) {
            this.botRecommendationStatus(botRecommendationStatus == null ? null : botRecommendationStatus.toString());
            return this;
        }

        public final String getBotRecommendationId() {
            return botRecommendationId;
        }

        public final void setBotRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
        }

        @Override
        public final Builder botRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public BotRecommendationSummary build() {
            return new BotRecommendationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
