/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;

public class ListBotVersionsPublisher
implements SdkPublisher<ListBotVersionsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListBotVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBotVersionsPublisher(LexModelsV2AsyncClient client, ListBotVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBotVersionsPublisher(LexModelsV2AsyncClient client, ListBotVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBotVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBotVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBotVersionsResponseFetcher
    implements AsyncPageFetcher<ListBotVersionsResponse> {
        private ListBotVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBotVersionsResponse> nextPage(ListBotVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListBotVersionsPublisher.this.client.listBotVersions(ListBotVersionsPublisher.this.firstRequest);
            }
            return ListBotVersionsPublisher.this.client.listBotVersions((ListBotVersionsRequest)((Object)ListBotVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

